﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace Curse.FriendsService.Tester
{
    public enum ServiceEnvironment
    {
        [Description("Development")]
        Dev=1,

        [Description("Staging")]
        Staging,

        [Description("Load Testing")]
        LoadTesting,

        [Description("Live (NA)")]
        NaLive,

        [Description("Live (EU)")]
        EuLive,

        [Description("Live (AP)")]
        ApLive,

        [Description("Live (CCloud)")]
        CCloudLive
    }

    public class ServiceConnectionInfo
    {
        public ServiceConnectionInfo(ServiceEnvironment environment)
        {
            UseLocalServices = environment == ServiceEnvironment.Dev;

            LoginInsecure = GetLoginUrl(environment);
            LoginSecure = MakeSecure(LoginInsecure);

            FriendsInsecure = GetFriendsUrl(environment);
            FriendsSecure = MakeSecure(FriendsInsecure);

            VoiceInsecure = GetVoiceUrl(environment);
            VoiceSecure = MakeSecure(VoiceInsecure);
        }

        private static string GetLoginUrl(ServiceEnvironment environment)
        {
            switch (environment)
            {
                case ServiceEnvironment.LoadTesting:
                    return "http://clientservice-v6.curse.opt/ClientLoginService.svc/Binary";
                case ServiceEnvironment.Dev:
                case ServiceEnvironment.Staging:
                    return "http://login.curseapp.tech/ClientLoginService.svc/Binary";
                default:
                    return "http://clientservice-v6-beta.curse.com/ClientLoginService.svc/Binary";
            }
        }

        private static string GetFriendsUrl(ServiceEnvironment environment)
        {
            switch (environment)
            {
                case ServiceEnvironment.LoadTesting:
                    return "http://friends-service.cursevoice.opt/FriendsService.svc";
                case ServiceEnvironment.Dev:
                    return "http://friends.curseapp.dev/FriendsService.svc";
                case ServiceEnvironment.Staging:
                    return "http://friends.curseapp.tech/FriendsService.svc";
                case ServiceEnvironment.NaLive:
                    return "http://friends-service.na-east.cursevoice.com/FriendsService.svc";
                case ServiceEnvironment.EuLive:
                    return "http://friends-service.eu-west.cursevoice.com/FriendsService.svc";
                case ServiceEnvironment.ApLive:
                    return "http://friends-service.ap-southeast.cursevoice.com/FriendsService.svc";
                default:
                    return "http://friends-service.ccloud.io/FriendsService.svc";

            }
        }

        private static string GetVoiceUrl(ServiceEnvironment environment)
        {
            switch (environment)
            {
                case ServiceEnvironment.LoadTesting:
                    return "http://voice-service.cursevoice.opt/CurseVoiceService.svc";
                case ServiceEnvironment.Dev:
                    return "http://voice.curseapp.dev/CurseVoiceService.svc";
                case ServiceEnvironment.Staging:
                    return "http://voice.curseapp.tech/CurseVoiceService.svc";
                default:
                    return "http://service-beta.cursevoice.com/CurseVoiceService.svc";
            }
        }

        private static string MakeSecure(string serviceUrlString)
        {
            var rightProtocol = "https://";
            var wrongProtocol = "http://";

            if (serviceUrlString.StartsWith(rightProtocol))
            {
                return serviceUrlString;
            }
            var fixedUrl = serviceUrlString.Replace(wrongProtocol, rightProtocol);

            return fixedUrl.StartsWith(rightProtocol) ? fixedUrl : rightProtocol + fixedUrl;
        }

        public string FriendsInsecure { get; private set; }

        public string FriendsSecure { get; private set; }

        public string VoiceInsecure { get; private set; }

        public string VoiceSecure { get; private set; }

        public string LoginInsecure { get; private set; }

        public string LoginSecure { get; private set; }

        public bool UseLocalServices { get; private set; }
    }
}
