﻿using System;
using System.ServiceModel;
using System.ServiceModel.Channels;
using Curse.CloudServices.Client;
using Curse.Friends.Client.FriendsService;

namespace Curse.FriendsService.Tester
{
    public class TestFriendsWebServiceClient : BaseServiceClient<TestFriendsWebServiceClient,IFriendsService,FriendsServiceClient>
    {
        private string _secureServiceUrl;
        private string _insecureServiceUrl;
        private TestAuthenticationToken _token;
        private readonly object _lockObject = new object();

        private bool _isInitialized;

        public TestFriendsWebServiceClient()
        {
            
        }

        public void InitializeInstance(string insecureServiceUrl, string secureServiceUrl)
        {
            _secureServiceUrl = insecureServiceUrl;
            _insecureServiceUrl = secureServiceUrl;
            _isInitialized = true;
        }

        public TestFriendsWebServiceClient(string insecureServiceUrl, string secureServiceUrl)
        {
            _secureServiceUrl = insecureServiceUrl;
            _insecureServiceUrl = secureServiceUrl;
            _isInitialized = true;
        }

        public void UpdateToken(TestAuthenticationToken token)
        {
            lock (_lockObject)
            {
                _token = token;
                if (_token == null)
                {
                    Close();
                }
            }
        }

        protected override bool RenewToken()
        {
            lock (_lockObject)
            {
                return _token != null && _token.Token == CurrentToken;
            }
        }

        protected override FriendsServiceClient CreateClient()
        {
            lock (_lockObject)
            {
                if (!_isInitialized || _token == null)
                {
                    throw new InvalidOperationException("You must initialize the client and authenticate before using it!");
                }

                CurrentToken = _token.Token;

                if (string.IsNullOrEmpty(CurrentToken))
                {
                    throw new InvalidOperationException("Unable to create a friends service client. Auth token is null or empty.");
                }

                var url = ServiceClientConfiguration.SslEnabled ? _secureServiceUrl : _insecureServiceUrl;

                Logger.Info("Creating new WCF client for endpoint at: " + url);

                return CreateFriendsClient(_token, url);
            }
        }

        private static FriendsServiceClient CreateFriendsClient(TestAuthenticationToken authToken, string uri)
        {
            CustomBinding binding;
            // The binding configuration
            if (uri.ToLowerInvariant().StartsWith("https://"))
            {
                binding = BindingHelper.GetBinaryBinding(true);
            }
            else
            {
                binding = BindingHelper.GetBinaryBinding(false);
            }

            // Create the client            
            var client = new FriendsServiceClient(binding, new EndpointAddress(uri));

            // Add the behaviour to send the credentials with each request
            client.ChannelFactory.Endpoint.Behaviors.Add(new TestAuthTokenExtension(authToken));

            return client;
        }
    }
}
