﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.ServiceModel;
using System.Text;
using System.Threading.Tasks;
using Curse.CloudServices.Client;
using Curse.FriendsService.Tester.ClientLoginService;

namespace Curse.FriendsService.Tester
{
    public class TestLoginServiceClient : BaseServiceClient<TestLoginServiceClient, IClientLoginService, ClientLoginServiceClient>
    {
        private Uri _secureBinaryLoginServiceUri;
        private Uri _insecureBinaryLoginServiceUri;
        private bool _isInitialized;

        public TestLoginServiceClient()
        {
            
        }

        public TestLoginServiceClient(string secureUrl, string insecureUrl)
        {
            _secureBinaryLoginServiceUri = new Uri(secureUrl.Replace("http://", "https://").Replace("CClientService.svc/Binary", "ClientLoginService.svc/Binary"));
            _insecureBinaryLoginServiceUri = new Uri(insecureUrl.Replace("https://", "http://").Replace("CClientService.svc/Binary", "ClientLoginService.svc/Binary"));
            _isInitialized = true;
        }

        public void InitializeInstance(string secureUri, string insecureUri)
        {
            _secureBinaryLoginServiceUri = new Uri(secureUri.Replace("http://","https://").Replace("CClientService.svc/Binary","ClientLoginService.svc/Binary"));
            _insecureBinaryLoginServiceUri = new Uri(insecureUri.Replace("https://","http://").Replace("CClientService.svc/Binary","ClientLoginService.svc/Binary"));
            _isInitialized = true;
        }

        protected override ClientLoginServiceClient CreateClient()
        {
            if (!_isInitialized)
            {
                throw new InvalidOperationException("Login Service is uninitialized");
            }

            var uri = ServiceClientConfiguration.SslEnabled
                ? _secureBinaryLoginServiceUri
                : _insecureBinaryLoginServiceUri;

            if (uri == null)
            {
                throw new Exception("Uninitialized.");
            }

            Logger.Info("Creating new WCF client for endpoint at: " + uri.AbsoluteUri);

            // The binding configuration
            var binding = BindingHelper.GetBinaryBinding(ServiceClientConfiguration.SslEnabled);

            // Create the client
            var client = new ClientLoginServiceClient(binding, new EndpointAddress(uri));

            return client;
        }

        protected override bool HandleServiceFault<V>(FaultException ex)
        {
            return false;
        }
    }
}
