﻿using System;
using System.ServiceModel;
using Curse.CloudServices.Client;
using Curse.FriendsService.Tester.CurseVoiceService;

namespace Curse.FriendsService.Tester
{
    public class TestVoiceServiceClient : BaseServiceClient<TestVoiceServiceClient, ICurseVoiceService, CurseVoiceServiceClient>
    {
        private string _serviceUrl;
        private string _secureServiceUrl;
        private bool _isInitialized;
        private TestAuthenticationToken _token;
        private readonly object _lockObject = new object();

        public TestVoiceServiceClient()
        {
            
        }

        public TestVoiceServiceClient(string secureServiceUrl, string insecureServiceUrl)
        {
            _secureServiceUrl = secureServiceUrl;
            _serviceUrl = insecureServiceUrl;
            _isInitialized = true;
        }

        public void InitializeInstance(string secureServiceUrl, string insecureServiceUrl)
        {
            _secureServiceUrl = secureServiceUrl;
            _serviceUrl = insecureServiceUrl;
            _isInitialized = true;
        }

        public void UpdateToken(TestAuthenticationToken token)
        {
            lock (_lockObject)
            {
                _token = token;
                if (_token == null)
                {
                    Close();
                }
            }
        }

        protected override CurseVoiceServiceClient CreateClient()
        {
            lock (_lockObject)
            {
                if (!_isInitialized || _token == null)
                {
                    throw new InvalidOperationException("Curse Voice Service Client not initialized or authenticated");
                }

                var token = _token.Token;
                if (string.IsNullOrEmpty(token))
                {
                    throw new InvalidOperationException("Unable to create a voice service client. Auth token is null or empty.");
                }


                var uri = ServiceClientConfiguration.SslEnabled ? _secureServiceUrl : _serviceUrl;

                Logger.Info("Creating new WCF client for endpoint at: " + uri);

                // Keep a copy of the token
                CurrentToken = token;

                // Create the client            
                var client = new CurseVoiceServiceClient(BindingHelper.GetBasicHttpBinding(ServiceClientConfiguration.SslEnabled), new EndpointAddress(uri));

                // Add the behaviour to send the credentials with each request
                client.ChannelFactory.Endpoint.Behaviors.Add(new TestAuthTokenExtension(_token));

                return client;
            }
        }

        protected override bool RenewToken()
        {
            lock (_lockObject)
            {
                return _token.Token == CurrentToken;
            }
        }
    }
}
