﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace GroupTestingPlayground
{
    public static class ConsoleHelper
    {
        private static bool _isAlive = true;
        private static Dictionary<string, Action> _commands = new Dictionary<string, Action>(StringComparer.InvariantCultureIgnoreCase);

        public static void RegisterCommand(string name, Action action)
        {
            _commands[name] = action;
        }

        public static void Kill()
        {
            _isAlive = false;
        }

        public static void Listen()
        {
            while (_isAlive)
            {
                
                PrintCommandOptions();
                
                var commandName = Console.ReadLine();
                Action commandAction;

                if (!_commands.TryGetValue(commandName, out commandAction))
                {
                    Console.WriteLine("Unknown command: " + commandName);
                    Console.WriteLine("Press any key to continue...");
                    Console.ReadKey();
                    continue;
                }

                try
                {
                    commandAction();
                }
                catch (Exception ex)
                {
                    Console.WriteLine("Failed with exception: " + ex.Message);
                }

                Console.WriteLine("Press any key to continue...");
                Console.ReadKey(true);
                
            }
        }

        private static void PrintCommandOptions()
        {
            Console.Clear();
            Console.WriteLine("Enter a command from the list below:");
            Console.WriteLine();
            foreach (var name in _commands.Keys)
            {
                Console.WriteLine(" " + name);
            }            
            Console.WriteLine();
        }
    }
}
