﻿using Curse.Friends.Configuration;
using Curse.Friends.Data;
using Curse.Friends.Data.Models;
using Curse.Friends.Enums;
using System;
using System.Collections.Generic;
using System.Data.SqlTypes;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using Aerospike.Client;
using Curse.Friends.Data.DerivedModels;
using Curse.Friends.Data.Queues;

namespace GroupTestingPlayground
{
    class Program
    {
        static void Main(string[] args)
        {
            StorageConfiguration.Initialize("GroupTestingPlayground", null, ConfigurationMode.Debug, ConfigurationServices.All);

            try
            {
                FixLegacyRanks();
                return;
                ConsoleHelper.RegisterCommand("Exit", Exit);
                ConsoleHelper.RegisterCommand("CreateTestRole", () => { CreateTestRole(TestAdminRoleID, TestAdminRoleName, true, TestAdminRolePermissions, true); });
                ConsoleHelper.RegisterCommand("CreateTestMember", CreateTestMember);
                ConsoleHelper.RegisterCommand("TestBitFields", TestBitField);
                ConsoleHelper.RegisterCommand("TestHugeCommunity", TestHugeCommunity);

                ConsoleHelper.Listen();
            }
            finally
            {
                StorageConfiguration.Shutdown();
            }

        }

        static void Exit()
        {
            ConsoleHelper.Kill();
        }



        static Guid TestGroupID = new Guid("9d0600d6-2b7b-4102-898c-69ed1a60044e");
        static string TestGroupTitle = "Permissions Test Group";
        static string TestGroupAvatarUrl = "http://clientupdate-v6.cursecdn.com/avatars/1/Chen.png";
        static int TestGroupCreatorID = 1;
        static int TestGroupMemberID = 128;

        static int TestAdminRoleID = 1;
        static string TestAdminRoleName = "Admins";
        static GroupPermissions TestAdminRolePermissions = GroupPermissions.All;

        static int TestMemberRoleID = 2;
        static string TestMemberRoleName = "Members";
        static GroupPermissions TestMemberPermissions = GroupPermissions.Access | GroupPermissions.ChatSendMessages | GroupPermissions.InviteUsers | GroupPermissions.ChatUploadPhotos | GroupPermissions.ChatAttachFiles | GroupPermissions.ChatEmbedLinks;

        static void FixLegacyRanks()
        {
            GroupMemberIndexWorker.CreateFullSync(Group.GetLocal("968b38c7-6f05-44f1-993a-6cb70c49dbcf"));
            return;

            var counter = 0;

            GroupRole.BatchOperateLocal(100, roles =>
            {
                foreach (var role in roles)
                {
                    if (role.IsDefault && role.Rank != GroupRole.DefaultRoleRank)
                    {
                        role.Rank = GroupRole.DefaultRoleRank;
                        role.Update(p => p.Rank);
                    }

                    if (++counter%10 == 0)
                    {
                        Console.Title = counter.ToString("N0");
                    }
                }
            });


           
            Console.WriteLine("Done!");
            Console.ReadKey(true);
        }

        static void TestHugeCommunity()
        {
            var numberOfUsers = 20000;
            var users = new List<User>();
            try
            {
                User.BatchOperateLocal(100, enumerable =>
                {
                    foreach (var user in enumerable)
                    {
                        users.Add(user);
                    }

                    if (users.Count >= numberOfUsers)
                    {
                        throw new AerospikeException.ScanTerminated();
                    }
                });
            }
            catch (AerospikeException.ScanTerminated)
            {
                
            }

            var group = Group.GetLocal("968b38c7-6f05-44f1-993a-6cb70c49dbcf");
            var role = group.DefaultRole;

            foreach (var user in users)
            {
                group.AddUsers(1, new[] { new NewGroupMember(user.UserID, 1, user.Username, role), });
            }



        }

        static void TestBitField()
        {
            Int64 allBits = 0;
            for (int i = 1; i <= 64; i++)
            {
                var mask = (Int64)Math.Pow(2, i - 1);
                allBits = allBits | mask;
                Console.WriteLine("All bits for " + i + ": " + allBits);
            }
        }

        static void CreateTestMember()
        {
            Group group = null;
            GroupRole adminRole = null;
            GroupRole memberRole = null;

            try
            {
                var user = User.GetLocal(TestGroupCreatorID);

                // First create a group
                group = new Group {
                     GroupID = TestGroupID,
                     RootGroupID = TestGroupID, 
                     ParentGroupID = TestGroupID,
                     AvatarUrl = TestGroupAvatarUrl,
                     CreatorID = TestGroupCreatorID,
                     Title = TestGroupTitle, 
                     Type = GroupType.Large, 
                     RegionID = StorageConfiguration.CurrentRegion.ID
                };

                group.InsertLocal();

                // Create the admin and member roles
                adminRole = CreateTestRole(TestAdminRoleID, TestAdminRoleName, true, GroupPermissions.All, false);                
                memberRole = CreateTestRole(TestMemberRoleID, TestMemberRoleName, false, TestMemberPermissions, false);
                                       
                // Next create an admin group membership
                var admin = new GroupMember
                {
                    GroupID = group.GroupID,
                    DateJoined = DateTime.UtcNow,                    
                    GroupMemberCount = 1,
                    GroupTitle = TestGroupTitle,
                    GroupType = group.Type,
                    ParentGroupID = group.ParentGroupID,
                    RootGroupID = group.RootGroupID,
                    UserID = TestGroupCreatorID,
                    Roles = new HashSet<int>(new[] { adminRole.RoleID, memberRole.RoleID })
                };
                
                admin.InsertLocal();
                
                // Next create an admin group membership
                var member = new GroupMember
                {
                    GroupID = group.GroupID,
                    DateJoined = DateTime.UtcNow,                    
                    GroupMemberCount = 1,
                    GroupTitle = TestGroupTitle,
                    GroupType = group.Type,
                    ParentGroupID = group.ParentGroupID,
                    RootGroupID = group.RootGroupID,
                    UserID = TestGroupMemberID,
                    Roles = new HashSet<int>(new[] { memberRole.RoleID })
                };
                
                member.InsertLocal();                
                
            }
            finally
            {
                if(group != null)
                {
                    group.Delete();
                }

                if (adminRole != null)
                {
                    adminRole.Delete();
                    var adminPermissions = GroupRolePermissions.GetLocal(adminRole.GroupID, adminRole.RoleID);
                    if(adminPermissions != null)
                    {
                        adminPermissions.Delete();
                    }
                }

                if (memberRole != null)
                {
                    memberRole.Delete();
                    var memberPermissions = GroupRolePermissions.GetLocal(memberRole.GroupID, memberRole.RoleID);
                    if (memberPermissions != null)
                    {
                        memberPermissions.Delete();
                    }
                }
            }
            

        }

        static GroupRole CreateTestRole(int roleID, string name, bool isOwner, GroupPermissions permissions, bool deleteRole = false)
        {
            var allPerms = Enum.GetValues(typeof(GroupPermissions));
            var permissionsState = new Dictionary<int, int>();
            foreach(var perm in allPerms)
            {
                if(permissions.HasFlag((GroupPermissions)perm))
                {
                    permissionsState.Add((int)perm, (int)GroupPermissionState.Allowed);
                }
            }
            
            var role = new GroupRole
            {
                GroupID = TestGroupID,
                RoleID = roleID,
                Rank = roleID,
                Name = name,
                IsOwner = isOwner,                
            };

            // Insert it
            role.InsertLocal();

            var rolePermissions = new GroupRolePermissions
            {
                GroupID = role.GroupID,
                RoleID = role.RoleID,
                RootGroupID = role.GroupID,
                PermissionsState = permissionsState,                
            };

            rolePermissions.InsertLocal();

            // See if the user has a permission
            var hasPermission = rolePermissions.Permissions.HasFlag(GroupPermissions.ManageServer);
            Console.WriteLine("Permission check: " + hasPermission);

            var insertedRole = GroupRole.GetLocal(TestGroupID, roleID);
            Console.WriteLine("Inserted Role Permissions: " + rolePermissions.Permissions);

            if(deleteRole)
            {
                insertedRole.Delete();
                rolePermissions.Delete();
            }

            return insertedRole;
            
        }
    }
}
