﻿using System;
using System.Collections.Generic;
using System.Diagnostics;
using System.IO;
using System.Linq;
using System.Security.Cryptography.X509Certificates;
using System.Text;
using System.Threading.Tasks;

namespace Curse.ConfigureLocalIIS
{
    public class CertCreator
    {       
        private string devCommandProcess = @"..\..\CreateCert.bat";
        private string originalTempFile; 
        private string pvkFile;
        private string cerFile;
        private string pfxFile;        

        public X509Certificate2 MakeCert(string cn)
        {
            if (!File.Exists(devCommandProcess))
            {
                Console.WriteLine("CreatCert.bat could not be found.");
                return null;
            }

            originalTempFile = Path.GetTempFileName();
            File.Delete(originalTempFile);
            pvkFile = originalTempFile.Replace(".tmp", ".pvk");
            cerFile = originalTempFile.Replace(".tmp", ".cer");
            pfxFile = originalTempFile.Replace(".tmp", ".pfx");

            ProcessStartInfo cmd = new ProcessStartInfo(devCommandProcess);
            cmd.Arguments = string.Format("{0} {1} {2} {3}", cn, pvkFile, cerFile, pfxFile);            
            Process creationProcess = Process.Start(cmd);
            creationProcess.WaitForExit();

            if (File.Exists(pfxFile))
            {
                string pw = null;
                return new X509Certificate2(pfxFile, pw, X509KeyStorageFlags.Exportable | X509KeyStorageFlags.MachineKeySet | X509KeyStorageFlags.PersistKeySet);
            }
            else
            {
               
                return null;
            }

        }

        public void Close()
        {            
            SafeDelete(pvkFile);
            SafeDelete(cerFile);
            SafeDelete(pfxFile);
        }

        private void SafeDelete(string file)
        {
            if (!string.IsNullOrWhiteSpace(file) && File.Exists(file))
            {
                try
                {
                    File.Delete(file);
                }
                catch { } // do nothing
            }

        }
    }
}
