﻿using System;
using System.Collections.Generic;
using System.IO;
using System.Linq;
using System.Security.Cryptography.X509Certificates;
using System.Text;
using System.Threading.Tasks;
using System.Xml;
using Microsoft.Web.Administration;
using Onion.SolutionParser.Parser;

namespace Curse.ConfigureLocalIIS
{
    class Program
    {
        static void Main(string[] args)
        {
            X509Certificate2 cert = null;
            //var store = new X509Store(StoreLocation.LocalMachine); //StoreLocation.LocalMachine fails too
            var store = new X509Store(StoreLocation.LocalMachine); //StoreLocation.LocalMachine fails too
            store.Open(OpenFlags.ReadWrite);
            var certificates = store.Certificates;
            foreach (var certificate in certificates)
            {
                if (!certificate.Subject.Contains("*.curseapp.dev") && !certificate.FriendlyName.Contains("*.curseapp.dev"))
                {
                    continue;
                }
                cert = certificate;
            }

            if (cert == null)
            {                
                CertCreator creator = new ConfigureLocalIIS.CertCreator();
                cert = creator.MakeCert("*.curseapp.dev");
                if (cert != null)
                {                                        
                    store.Add(cert);
                }
                creator.Close();
            }

            store.Close();

            var solutionFile = args.Length > 0 ? args[0] : @"..\..\..\..\Curse.Friends.MicroServices.sln";
            var solutionDirectory = solutionFile.Substring(0, solutionFile.LastIndexOf("\\"));

            solutionFile = Path.GetFullPath(solutionFile);

            var iisManager = new ServerManager();
            var solution = SolutionParser.Parse(solutionFile);
            foreach (var project in solution.Projects)
            {
                var absolutePath = Path.GetFullPath(Path.Combine(solutionDirectory, project.Path));
                // Solution Folders appear as projects apparently
                if (Path.GetExtension(absolutePath) != ".csproj")
                {
                    continue;
                }

                var xmldoc = new XmlDocument();
                xmldoc.Load(absolutePath);

                var xmlManager = new XmlNamespaceManager(xmldoc.NameTable);
                xmlManager.AddNamespace("x", "http://schemas.microsoft.com/developer/msbuild/2003");

                var webProperties = xmldoc.SelectSingleNode("//x:WebProjectProperties", xmlManager);
                if (webProperties == null || webProperties["UseIIS"] == null || webProperties["IISUrl"] == null)
                {
                    continue;
                }
                var useIIS = webProperties["UseIIS"]?.InnerText;
                if (useIIS != "True")
                {
                    continue;
                }

                var url = new Uri(webProperties["IISUrl"].InnerText);
                var dotIndex = project.Name.Count(c => c == '.');
                var siteName = dotIndex > 0 ? project.Name.Split('.')[dotIndex] : project.Name;
                var sitePath = Path.GetDirectoryName(project.Path) + "\\";

                if (iisManager.Sites.Any(s => s.Name == siteName))
                {
                    continue;
                }

                var site = iisManager.Sites.Add(siteName, sitePath, 80);

                site.Bindings.Clear();
                site.Bindings.Add("*:80:" + url.Host, "http");

                Console.WriteLine(site.Name + " [" + url.Scheme + "]");

                var enabledProtocols = "http";
                if (cert != null)
                {
                    site.Bindings.Add("*:443:" + url.Host, cert.GetCertHash(), "MY");
                    enabledProtocols += ",https";
                }
                site.ApplicationDefaults.EnabledProtocols = enabledProtocols;
            }

            iisManager.CommitChanges();

            Console
                .ReadLine();
        }
    }
}
