﻿using Curse.Aerospike;
using Curse.Friends.Configuration;
using Curse.Friends.Data;
using Curse.Friends.Enums;
using Curse.VaultSharp;
using System;
using System.IO;
using System.Linq;

namespace Curse.Friends.Aerospike.BatchTools
{
    class Program
    {
        static void Main(string[] args)
        {
            //VaultSharpHelper.ReplaceSecrets(@"C:\temp\Release", "release");
            //return;
#if DEBUG
            StorageConfiguration.Initialize("BatchTools", ConfigurationRegion.USEast.Key, ConfigurationMode.Debug, ConfigurationServices.All);
#else
            StorageConfiguration.Initialize("BatchTools");
#endif
            try
            {
                AddSubTiers();
                Console.WriteLine("Done");
                Console.ReadLine();
            }
            finally
            {
                StorageConfiguration.Shutdown();
            }

        }

        private static void AddSubTiers()
        {
            LogMessage("Creating ExternalCommunityRoles and corresponding GroupRoles", true);
            var total = 0;
            var partners = 0;
            var groupRoleCount = 0;
            var relevantTags = new[] { GroupRoleTag.SyncedSubscriberTier3, GroupRoleTag.SyncedSubscriberTier2 };
            ExternalCommunity.BatchOperateLocal(1000, comms =>
            {
                foreach (var comm in comms)
                {
                    total++;
                    if (!comm.IsPartnered)
                    {
                        continue;
                    }
                    partners++;
                    try
                    {
                        TwitchModelHelper.CreateOrUpdateCommunityRoles(comm.ExternalID, comm.ExternalName);
                        var roles = ExternalCommunityRole.MultiGetLocal(relevantTags.Select(t => new KeyInfo(comm.ExternalID, comm.Type, t)));
                        foreach (var group in Group.MultiGetLocal(comm.MappedGroups.Select(id => new KeyInfo(id))))
                        {
                            try
                            {
                                var groupRoles = group.GetRoles(true);
                                foreach (var role in roles)
                                {
                                    Group.CreateSyncedRole(group, role, groupRoles);
                                    groupRoleCount++;
                                }
                            }
                            catch(Exception ex)
                            {
                                LogMessage($"Exception while creating synced roles for {comm.ExternalID} - {group.GroupID}: {ex.Message}", true);
                            }
                        }
                    }
                    catch (Exception ex)
                    {
                        LogMessage($"Exception while processing {comm.ExternalID}: {ex.Message}", true);
                    }
                }
                LogMessage($"Finished processing {partners}/{total} communities, {groupRoleCount} group roles");
            });
            LogMessage($"Completed creating roles. ExternalCommunityRoles: {partners}/{total}, GroupRoles: {groupRoleCount}.", true);
        }

        private static void LogMessage(string message, bool writeToFile = false)
        {
            var now = DateTime.UtcNow;
            var logMessage = $"{now.ToString("s")}: {message}";

            Console.WriteLine(logMessage);

            if (writeToFile)
            {
                using (var stream = File.AppendText("log.txt"))
                {
                    stream.WriteLine(logMessage);
                }
            }
        }
    }
}
