﻿using System;
using Curse.Friends.Configuration;

namespace Curse.Friends.ElasticIndexer
{
    class Program
    {
        static void Main(string[] args)
        {
            const string title = "Elastic Indexer";
            Console.Title = title;

            ConfigurationMode configMode = ConfigurationMode.Debug;
            var modeSelected = false;
            while (!modeSelected)
            {
                Console.Clear();
                Console.WriteLine("What configuration mode do you want to use?");
                foreach (var config in Enum.GetValues(typeof (ConfigurationMode)))
                {
                    Console.WriteLine("- {0}", config);
                }
                var input = Console.ReadLine();
                modeSelected = Enum.TryParse(input, out configMode);
            }

            Console.Title = string.Format("{0} - {1}", title, configMode);

            ConfigurationRegion configRegion = null;
            while (configRegion==null)
            {
                Console.Clear();
                Console.WriteLine("What region do you want to process?");
                foreach (var region in ConfigurationRegion.AllRegions)
                {
                    Console.WriteLine("{0} - {1}", region.ID, region.Key);
                }

                var input = Console.ReadLine();
                int regionID;
                if (!int.TryParse(input, out regionID))
                {
                    continue;
                }
                configRegion = ConfigurationRegion.FindRegionByID(regionID);
            }

            Console.Title = string.Format("{0} - {1} - {2}", title, configMode, configRegion.Key);

            StorageConfiguration.Initialize("ElasticIndexer", configRegion.Key, configMode);

            var exitRequested = false;
            while (!exitRequested)
            {
                Console.Clear();
                Console.WriteLine("What do you want to reindex?");
                Console.WriteLine("0 - Group Members");
                Console.WriteLine("1 - Groups");
                Console.WriteLine("2 - Group Banned Users");
                Console.WriteLine("3 - External Communities");
                Console.WriteLine("Esc - Exit");

                var key = Console.ReadKey(true);
                switch (key.Key)
                {
                    case ConsoleKey.Escape:
                        exitRequested = true;
                        break;
                    case ConsoleKey.D0:
                        GroupMemberIndexer.Index(configRegion);
                        break;
                    case ConsoleKey.D1:
                        GroupIndexer.Index(configRegion);
                        break;
                    case ConsoleKey.D2:
                        GroupBannedUserIndexer.Index(configRegion);
                        break;
                    case ConsoleKey.D3:
                        ExternalCommunityIndexer.Index(configRegion);
                        break;
                }
            }

            // Shut down
            StorageConfiguration.Shutdown();
        }
    }
}
