﻿using System;
using System.Collections.Generic;
using System.IO;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using Curse.CloudSearch;
using Curse.Extensions;
using Curse.Friends.Configuration;
using Curse.Friends.Data.Messaging;
using Curse.Friends.Enums;
using Elasticsearch.Net;

namespace Curse.Friends.MessageCounter
{
    class Program
    {
        static void Main(string[] args)
        {
            // TODO: Allow command line args

            var fileName = @"C:\temp\MessageCount.txt";
            var mode = ConfigurationMode.Release;

            var interval = TimeSpan.FromMinutes(15);

            var startDate = DateTime.UtcNow.Date.AddDays(-1);

            var now = DateTime.UtcNow;
            var endDate = new DateTime(now.Year, now.Month, now.Day, now.Hour, now.Minute - (now.Minute%15) + 15, 0, DateTimeKind.Utc);
            
            CountMessages(startDate, endDate, interval, fileName, mode);
        }

        private static void CountMessages(DateTime startTime, DateTime endTime, TimeSpan interval, string fileName, ConfigurationMode mode)
        {
            StorageConfiguration.Initialize("Tester", "US-East", mode, ConfigurationServices.Search);

            var client = ConversationManager.GetClient();

            var current = startTime;
            var next = startTime + interval;

            var lines = new List<string>();
            var types = Enum.GetValues(typeof(ConversationType)).Cast<ConversationType>().OrderBy(t => t).ToArray();
            lines.Add(string.Format("End of Interval,Total,{0}", string.Join(",", types)));
            var res = new List<long>();
            while (current < endTime)
            {
                var months = TimeSeriesIndexing.GetMonthsBetween(current, next);
                var results = client.Search<ConversationMessage>(s => s
                    .Indices(months.Select(d => TimeSeriesIndexing.GetIndexName(ConversationManager.IndexTypeName, d.Year, d.Month)))
                    .SearchType(SearchType.Count)
                    .Query(f => f.Range(r => r.OnField(t => t.Timestamp).GreaterOrEquals(current.ToEpochMilliseconds()).Lower(next.ToEpochMilliseconds())))
                    .Aggregations(a => a
                        .Terms("t", ta => ta.Field(taf => taf.ConversationType)))
                    );

                res.Add(results.Total);


                var dict = results.Aggs.Terms("t").Items.ToDictionary(i => int.Parse(i.Key), i => i.DocCount);
                var values = new List<long>();
                foreach (var type in types)
                {
                    long count;
                    dict.TryGetValue((int)type, out count);
                    values.Add(count);
                }
                var line = string.Format("{0},{1},{2}", next.ToString("G"), results.Total, string.Join(",", values));
                lines.Add(line);

                Console.WriteLine("------{0}-----", next.ToString("G"));
                Console.WriteLine("Total: {0}", results.Total);
                foreach (var v in dict)
                {
                    Console.WriteLine("{0}: {1}", (ConversationType)v.Key, v.Value);
                }
                Console.WriteLine();

                current = next;
                next += interval;
            }

            File.WriteAllLines(fileName, lines, Encoding.UTF8);
            StorageConfiguration.Shutdown();
            Console.ReadLine();
        }
    }
}
