﻿using System;
using System.Collections.Concurrent;
using System.IO;
using System.Linq;
using System.Text;
using Curse.Friends.Enums;
using Curse.Friends.StatsTool.ExternalAccountMapping;

namespace Curse.Friends.StatsTool.ExternalCommunity
{
    public class ExternalAccountMappingStats
    {
        public static ExternalAccountMappingData[] GetExternalAccountMappings()
        {
            var data = new ConcurrentDictionary<Tuple<string, AccountType>, ExternalAccountMappingData>();
            var count = 0;
            Data.ExternalAccountMapping.BatchOperateLocal(1000, mappings =>
            {
                foreach (var mapping in mappings)
                {
                    count++;
                    var datum = new ExternalAccountMappingData
                    {
                        ExternalID = mapping.ExternalID,
                        Type = mapping.Type,
                        ExternalName = mapping.ExternalName,
                        LinkTimestamp = mapping.DateMapped,
                        CurseAccountsLinked = 1
                    };
                    var key = new Tuple<string, AccountType>(mapping.ExternalID, mapping.Type);
                    if (!data.TryAdd(key, datum))
                    {
                        var existing = data[key];
                        existing.CurseAccountsLinked += 1;
                        existing.LinkTimestamp = existing.LinkTimestamp < datum.LinkTimestamp ? datum.LinkTimestamp : existing.LinkTimestamp;
                    }
                }

                Console.Write("\rProcessed {0} external account mappings", count);
            });
            Console.WriteLine();
            return data.Values.ToArray();
        }

        public static void WriteExternalAccountMappingStats(string basePath)
        {
            Console.Clear();
            var date = DateTime.Now.Date.ToString("yyyy-MM-dd");
            var filename = "external-account-mapping-stats.csv";
            var filePath = string.Format(@"{0}\{1}\{2}", basePath, date, filename);
            Directory.CreateDirectory(string.Format(@"{0}\{1}", basePath, date));

            Console.WriteLine("Getting external account mapping info");
            var mappings = GetExternalAccountMappings();

            Console.WriteLine("Writing external account mapping info to {0}", filePath);
            var sb = new StringBuilder().AppendLine("Account Type,External ID,External Name,Link Timestamp,# Curse Accounts Linked");
            foreach (var mapping in mappings)
            {
                sb.AppendLine(string.Format("{0},{1},{2},{3},{4}", mapping.Type, mapping.ExternalID, mapping.ExternalName, mapping.LinkTimestamp.ToString("G"), mapping.CurseAccountsLinked));
            }

            File.WriteAllText(filePath, sb.ToString());
        }
    }
}
