﻿using System;
using System.Collections.Concurrent;
using System.IO;
using System.Linq;
using System.Text;
using Curse.Friends.Data;
using Curse.Friends.Enums;

namespace Curse.Friends.StatsTool.Giveaways
{
    class GiveawayStats
    {
        public static GiveawayData[] GetGiveaways()
        {
            var data = new ConcurrentBag<GiveawayData>();

            var count = 0;
            GroupGiveaway.BatchOperateLocal(500, giveaways =>
            {
                var giveawaysArray = giveaways.Where(g => g.Status == GroupGiveawayStatus.Ended || g.Status == GroupGiveawayStatus.Inactive).ToArray();

                foreach (var giveaway in giveawaysArray)
                {
                    var giveawayData = CreateGiveawayData(giveaway);
                    data.Add(giveawayData);
                }

                count += giveawaysArray.Length;
                Console.Write("\rProcessed {0} giveaways", count);
            });

            Console.WriteLine();
            return data.ToArray();
        }

        private static GiveawayData CreateGiveawayData(GroupGiveaway giveaway)
        {
            return new GiveawayData
            {
                GroupID = giveaway.GroupID,
                GiveawayID = giveaway.GiveawayID,
                Title = giveaway.Title,
                CreationTimestamp = giveaway.DateStarted,
                TotalEntries = giveaway.TotalEntries,
                TotalRolls = giveaway.CurrentRoll
            };
        }

        public static void WriteGiveawayStats(string basePath)
        {
            Console.Clear();
            var date = DateTime.Now.Date.ToString("yyyy-MM-dd");
            var filename = "giveaway-stats.csv";
            var filePath = string.Format(@"{0}\{1}\{2}", basePath, date, filename);
            Directory.CreateDirectory(string.Format(@"{0}\{1}", basePath, date));

            Console.WriteLine("Getting giveaway info");
            var giveaways = GetGiveaways();

            Console.WriteLine("Writing giveaway info to {0}", filePath);

            var sb = new StringBuilder().AppendLine("Group ID,Giveaway ID,Title,Created,Entries,Rolls");
            foreach (var giveaway in giveaways)
            {
                sb.AppendLine(string.Format("{0},{1},{2},{3},{4},{5}", giveaway.GroupID, giveaway.GiveawayID, giveaway.Title, giveaway.CreationTimestamp.ToString("G"), giveaway.TotalEntries, giveaway.TotalRolls));
            }

            File.WriteAllText(filePath, sb.ToString());
        }
    }
}
