﻿using System;
using System.Collections.Generic;
using System.IO;
using System.Linq;
using System.Text;
using Curse.Aerospike;
using Curse.Friends.Data;
using Curse.Friends.Data.Search;
using Curse.Friends.StatsTool.Models;

namespace Curse.Friends.StatsTool.Groups
{
    public class GroupStats
    {
        public static GroupData[] GetGroupStats()
        {
            var groups = new List<GroupData>();
            var client = GroupSearchManager.GetClient();

            var size = 1000;
            var skip = 0;

            var res = client.Search<GroupSearchModel>(s => s
                .Index(GroupSearchManager.IndexName)
                .Size(size)
                .Skip(skip)
                .Scroll("30s")
                );

            while (res.Documents.Any())
            {
                var allGroups = Group.MultiGetLocal(res.Documents.Select(g => new KeyInfo(g.GroupID))).ToLookup(g => g.GroupID);
                foreach (var doc in res.Documents)
                {
                    var g = allGroups[doc.GroupID].FirstOrDefault();
                    groups.Add(new GroupData
                    {
                        GroupID = doc.GroupID,
                        IsPublic = doc.IsPublic,
                        MemberCount = doc.MemberCount,
                        OwnerUserID = doc.OwnerUserID,
                        OwnerUsername = doc.OwnerUsername,
                        Title = doc.GroupTitle,
                        CreationTimestamp = g==null?DateTime.MinValue:g.DateCreated,
                    });
                }

                Console.Write("\rProcessed {0} total servers", groups.Count);

                res = client.Scroll<GroupSearchModel>(s => s.ScrollId(res.ScrollId).Scroll("30s"));
            }

            Console.WriteLine();
            return groups.ToArray();
        }

        public static void WriteGroupStats(string basePath)
        {
            Console.Clear();
            var date = DateTime.Now.Date.ToString("yyyy-MM-dd");
            var filename = "group-stats.csv";
            var filePath = string.Format(@"{0}\{1}\{2}", basePath, date, filename);
            Directory.CreateDirectory(string.Format(@"{0}\{1}", basePath, date));

            Console.WriteLine("Getting group info");
            var groups = GetGroupStats();

            Console.WriteLine("Writing group info to {0}", filePath);

            var sb = new StringBuilder().AppendLine("ID,Title,Members,Public,Created,Owner ID,Owner Username");
            foreach (var group in groups)
            {
                sb.AppendLine(string.Format("{0},{1},{2},{3},{4},{5},{6}", group.GroupID, group.Title, group.MemberCount, group.IsPublic, group.CreationTimestamp.ToString("G"), group.OwnerUserID, group.OwnerUsername));
            }

            File.WriteAllText(filePath, sb.ToString());
        }
    }
}
