﻿using System;
using System.Linq;
using Curse.Friends.Configuration;
using Curse.Friends.Data;
using Curse.Friends.Data.Queues;
using Curse.Friends.Enums;

namespace Curse.Friends.WorkerTests
{
    class Program
    {
        static void Main(string[] args)
        {
            StorageConfiguration.Initialize("QueueTests", ConfigurationRegion.USEast.Key, ConfigurationMode.Debug);
            TestFriendCallResolver();
        }

        static void TestFriendCallResolver()
        {
            var testCallDetails = new CallDetails
            {
                CallID = "TEST",
                ConversationID = "1:128",
                CreatorID = 128,
                CreatorName = "Net",
                HostID = 1,
                GameID = 1,
                HostName = "voice-test.curse.audio",
                InviteCode = "TEST",
                InviteUrl = "https://cv.gg/test",
                Timestamp = DateTime.UtcNow,
                Type = CallType.Friend
            };

            CallResolver.Create(128, "Net", 1, testCallDetails);
        }

        static void TestFriendCallPushNotification()
        {
            var testEp = ClientEndpoint.GetAllLocal(p => p.UserID, 1).FirstOrDefault();
            var testCallDetails = new CallDetails
            {
                CallID = "TEST",
                ConversationID = "1:128",
                CreatorID = 1,
                CreatorName = "Adamar",
                HostID = 1,
                GameID = 1,
                HostName = "voice-test.curse.audio",
                InviteCode = "TEST",
                InviteUrl = "https://cv.gg/test",
                Timestamp = DateTime.UtcNow,
                Type = CallType.Friend
            };

            PushNotificationWorker.VoiceInvite(ConfigurationRegion.USEast.ID, testEp, 128, "Net", 1, testCallDetails, 0);
        }

        static void TestAdHocCallPushNotification()
        {
            var testEp = ClientEndpoint.GetAllLocal(p => p.UserID, 1).FirstOrDefault();
            var testCallDetails = new CallDetails
            {
                CallID = "TEST",
                ConversationID = null,
                CreatorID = 222,
                CreatorName = "Testperson",
                HostID = 1,
                GameID = 1,
                HostName = "voice-test.curse.audio",
                InviteCode = "TEST",
                InviteUrl = "https://cv.gg/test",
                Timestamp = DateTime.UtcNow,
                Type = CallType.AdHoc
            };

            PushNotificationWorker.VoiceInvite(ConfigurationRegion.USEast.ID, testEp, 222, "TestPerson", 1, testCallDetails, 0);
        }

        static void TestGroupCallPushNotification()
        {
            var testEp = ClientEndpoint.GetAllLocal(p => p.UserID, 1).FirstOrDefault();
            var testCallDetails = new CallDetails
            {
                CallID = "TEST",
                ConversationID = "968b38c7-6f05-44f1-993a-6cb70c49dbcf",
                CreatorID = 1,
                CreatorName = "Adamar",
                HostID = 1,
                GameID = 1,
                HostName = "voice-test.curse.audio",
                InviteCode = "TEST",
                InviteUrl = "https://cv.gg/test",
                Timestamp = DateTime.UtcNow,
                Type = CallType.Group
            };

            PushNotificationWorker.VoiceInvite(ConfigurationRegion.USEast.ID, testEp, 128, "Net", 1, testCallDetails, 0);
        }
    }
}
