﻿using Curse.Friends.Configuration;
using Curse.Friends.Data;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Reflection;
using System.Text;
using System.Threading.Tasks;
using Curse.Extensions;
using Curse.Logging;
using Curse.VaultSharp;
using Curse.Friends.Data.DerivedModels;

namespace Curse.Tools.AddGroupMembership
{
    class Program
    {
        static void Main(string[] args)
        {
#if DEBUG
            var mode = ConfigurationMode.Debug;
#else
                var mode = ConfigurationMode.Release;
            VaultSharpHelper.ReplaceSecrets(AppDomain.CurrentDomain.BaseDirectory, "release");
#endif
            
            StorageConfiguration.Initialize("AddGroupMembership", ConfigurationRegion.USEast.Key, mode, ConfigurationServices.Database | ConfigurationServices.LocalOnly);

            Console.WriteLine("Running in {0} mode.", mode);

            string groupID = "344e775b-0643-454d-b193-0217e402d61a";
            int userID = 41890409;
            // add member
            var group = Group.GetByID(groupID);
            group.OwnerID = userID;             
            var member = GroupMember.Get(1, new object[] { groupID, userID });            
            member.Roles.Clear();
            member.AddRole(group.OwnerRole);
            member.BestRole = group.OwnerRole.RoleID;
            member.BestRoleRank = group.OwnerRole.Rank;
            member.Update();
            group.Update(x => x.OwnerID);
            //var member = new GroupMember(group, 21622463, "HellFir3", "Twitch Support", 1, null, Friends.Enums.NotificationPreference.Enabled, new[] { group.OwnerRole });
            //member.Insert(group.RegionID);
            
            // update existing member (cust support only please!!)
            //var chelsea = group.GetMembers(new[] { 21622463 }).FirstOrDefault();
            //if(chelsea != null)
            //{                
            //    chelsea.Roles = new HashSet<int> { 1 };
            //}
            //chelsea.Update(x => x.Roles);





            //group.AddUsers(36584450, new NewGroupMember { UserID = 21622463, RegionID = 1, Role = group.DefaultRole,  )

            Console.ReadLine();
        }              
    }
}
