﻿using Curse.Friends.Configuration;
using Curse.Friends.Data;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Reflection;
using System.Text;
using System.Threading.Tasks;
using Curse.Extensions;
using Curse.Logging;
using Curse.VaultSharp;
using Curse.Friends.Data.DerivedModels;

namespace Curse.Tools.AddGroupMembership
{
    class Program
    {
        static void Main(string[] args)
        {
#if DEBUG
            var mode = ConfigurationMode.Debug;
#else
                var mode = ConfigurationMode.Release;
            VaultSharpHelper.ReplaceSecrets(AppDomain.CurrentDomain.BaseDirectory, "release");
#endif
            
            StorageConfiguration.Initialize("DisolveUserFriendship", ConfigurationRegion.EuropeWest.Key, mode, ConfigurationServices.Database);

            Console.WriteLine("Running in {0} mode.", mode);

          
            int userID = 24894042;

            var friendships = Friendship.GetAllConfirmed(3, userID);
          
            foreach (var f in friendships)
            {
                try
                {
                    Console.WriteLine($"{f.DisplayName} -> {f.OtherUserDisplayName}: {f.Status.ToString()}");
                    FriendshipContext context = new FriendshipContext(userID, f.OtherUserID);
                    Friendship.Remove(false, context.Me, f, context.MyRegion, context.Them,
                        context.GetTheirFriendship(false), context.TheirRegion);
                }
                catch
                {
                }
            }

          
          
            Console.ReadLine();
        }              
    }
}
