﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using Curse.Friends.Configuration;
using Curse.Friends.ImageManager;
using Curse.VaultSharp;

namespace Curse.Tools.StorageExplorer
{
    class Program
    {
        static void Main(string[] args)
        {

            var mode = ConfigurationMode.Release;

            switch (mode)
            {
                case ConfigurationMode.Release:
                case ConfigurationMode.Beta:
                    VaultSharpHelper.ReplaceSecrets(AppDomain.CurrentDomain.BaseDirectory, "release");
                    break;
                case ConfigurationMode.Staging:
                    VaultSharpHelper.ReplaceSecrets(AppDomain.CurrentDomain.BaseDirectory, "staging");
                    break;
            }

            StorageConfiguration.Initialize("StorageExplorer", null, mode, ConfigurationServices.None);
            ImageManager.Initialize();
            Console.Clear();

            var fileID = args[0];
            var filename = args[1];

            Console.WriteLine("Attempting to get resource...");

            ImageMetadata imageMetadata;
            using (var stream = ImageManager.GetImageStream(fileID, filename, out imageMetadata))
            {
                if (stream == null)
                {
                    Console.WriteLine("Resource not found!");
                }
                else
                {
                    Console.WriteLine("Resource found!");

                }
            }

            Console.ReadKey(true);

        }
    }
}
