﻿using CsvHelper;
using Curse.Friends.Configuration;
using Curse.VaultSharp;
using System;
using System.Collections.Generic;
using System.Diagnostics;
using System.IO;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Forms;

namespace TwitchGameComparison
{
    class Program
   {
        [STAThread]
        static void Main(string[] args)
        {
#if DEBUG
            var mode = ConfigurationMode.Debug;
#else
                var mode = ConfigurationMode.Release;
            VaultSharpHelper.ReplaceSecrets(AppDomain.CurrentDomain.BaseDirectory, "release");
#endif
            StorageConfiguration.Initialize("TwitchGameIDMappingTool", ConfigurationRegion.USEast.Key, mode, ConfigurationServices.Database);

            Console.Clear();
            Console.WriteLine("Available Operations:");
            Console.WriteLine("1: Generate differences between Curse and Twitch GameIDs.");
            Console.WriteLine("2: Insert a list of Curse-Twitch GameID mappings to Aerospike.");
            int choice = PromptNumber("Please enter a number from the above options:", new int[] { 1, 2 });            

            switch (choice)
            {
                case 1:
                    bool exludeAerospikeMatches = PromptYesNo("Exclude curse games already saved to aerospike? (y/n):");                    
                    GenerateComparison.Execute(exludeAerospikeMatches);
                    break;
                case 2:
                    UploadData.Execute();
                    break;                   
            }

            Console.WriteLine("Complete.");
            Console.ReadLine();
        }

        private static int PromptNumber(string question, int[] allowedResponses)
        {
            int choice = 0;
            string choiceStr;
            Console.WriteLine(question);
            while (true)
            {                
                choiceStr = Console.ReadLine();
                if (int.TryParse(choiceStr, out choice))
                {
                    if (allowedResponses == null || allowedResponses.Length == 0)
                    {
                        return choice;
                    }
                    else if (allowedResponses.Contains(choice))
                    {
                        return choice;
                    }
                    else
                    {
                        Console.WriteLine("Number is not in the allowed responses.");
                    }
                }
                else
                {
                    Console.WriteLine("Only numbers are valid responses.");
                }
                
            }            
        }

        private static bool PromptYesNo(string question)
        {            
            string choiceStr;            
            Console.WriteLine(question);
            while(true)
            {
                choiceStr = Console.ReadLine();
                if (String.Equals(choiceStr, "y", StringComparison.CurrentCultureIgnoreCase))
                {
                    return true;
                }
                else if (String.Equals(choiceStr, "n", StringComparison.CurrentCultureIgnoreCase))
                {
                    return false;
                }
                else
                {
                    Console.WriteLine("Only 'y' or 'n' are valid responses.");
                }
            }
            
        }

    }
}
