﻿using CsvHelper;
using Curse.Aerospike;
using Curse.Friends.Configuration;
using Curse.Friends.Data.Models;
using System;
using System.Collections.Generic;
using System.IO;
using System.Linq;
using System.Windows.Forms;

namespace TwitchGameComparison
{
    public static class UploadData
    {

        public static void Execute()
        {                                    
            // get csv file to load and map to MatchRecord            
            var dlg = new OpenFileDialog();
            dlg.Filter = "CSV|*.csv";
            dlg.Title = "Data to Upload";
            var dataFile = string.Empty;
            if (dlg.ShowDialog() == DialogResult.OK)
            {
                dataFile = dlg.FileName;
            }
            else
            {
                Console.WriteLine("No upload file selected.");
                return;
            }

            var pendingItems = new List<MatchGameRecord>();
            if (!string.IsNullOrWhiteSpace(dataFile))
            {
                using (TextReader reader = File.OpenText(dataFile))
                {
                    var csv = new CsvReader(reader);
                    while (csv.Read())
                    {
                        pendingItems.Add(new MatchGameRecord
                        {
                            Name = csv.GetField("Name"),
                            CurseID = csv.GetField<int>("CurseID"),
                            TwitchID = csv.GetField<int>("TwitchID")
                        });
                    }
                }
            }

            if (!pendingItems.Any())
            {
                Console.WriteLine("No items loaded from the given spreadsheet.");
                return;
            }

            // get all items where the curseid already exists in aerospike and update the twitch id and gamename to match.             
            var storedItems = new List<TwitchGameMapping>();
            storedItems.AddRange(TwitchGameMapping.GetAllLocal(x => x.IndexMode, IndexMode.Default));

            var updated = 0;
            var inserted = 0;
            foreach (var pending in pendingItems)
            {
                var stored = storedItems.FirstOrDefault(x => x.CurseGameID == pending.CurseID);
                if (stored != null)
                {
                    bool u = false;
                    if (pending.TwitchID > 0 && pending.TwitchID != stored.TwitchGameID)
                    {
                        stored.TwitchGameID = pending.TwitchID;
                        stored.Update(x => x.TwitchGameID);
                        u = true;
                    }
                    if (!string.IsNullOrWhiteSpace(pending.Name) && !pending.Name.Equals(stored.GameName))
                    {
                        stored.GameName = pending.Name;
                        stored.Update(x => x.GameName);
                        u = true;
                    }
                    if (u)
                    {
                        updated++;
                    }
                }
                else
                {
                    new TwitchGameMapping()
                    {
                        CurseGameID = pending.CurseID,
                        GameName = pending.Name,
                        TwitchGameID = pending.TwitchID
                    }.InsertLocal();
                    inserted++;
                }
            }

            // confirm to console # of updates and new additions.            
            Console.WriteLine(string.Format("# of items updated: {0}", updated));
            Console.WriteLine(string.Format("# of items inserted: {0}", inserted));


        }
    }
}
