﻿using Curse.Friends.Configuration;
using Curse.Friends.Data;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Reflection;
using System.Text;
using System.Threading.Tasks;
using Curse.Extensions;
using Curse.Logging;
using Curse.VaultSharp;

namespace UpdateInvitationTimestamps
{
    class Program
    {
        static void Main(string[] args)
        {
#if DEBUG
            var mode = ConfigurationMode.Debug;
#else
                var mode = ConfigurationMode.Release;
            VaultSharpHelper.ReplaceSecrets(AppDomain.CurrentDomain.BaseDirectory, "release");
#endif
            
            StorageConfiguration.Initialize("UpdateInvitationTimestamps", ConfigurationRegion.USEast.Key, mode, ConfigurationServices.Database | ConfigurationServices.LocalOnly);

            Console.WriteLine("Running in {0} mode.", mode);

            var count = 0;
            var batchSize = 1000;
            GroupInvitation.BatchOperateLocal(batchSize, list =>
            {
                foreach (var invite in list)
                {
                    Update(invite);
                    count++;
                }
                Console.WriteLine("updated {0} items", count);
            });
              
            Console.ReadLine();
        }
        
        private static void Update(GroupInvitation invite)
        {
            if (invite.ExpirationTimestamp == 0L)
            {
                invite.ExpirationTimestamp = invite.DateExpires.ToEpochMilliseconds();
                invite.Update(x => x.ExpirationTimestamp);
            }
        }        
    }
}
