﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Net;
using System.Security.Cryptography;
using System.Text;
using System.Threading.Tasks;
using Curse.VaultSharp;

namespace Curse.Tools.VaultTool
{
    class Program
    {
        private static RandomNumberGenerator _generator;

        static void Main(string[] args)
        {
            VaultSharpHelper.InitializeConnection();

            ServicePointManager.SecurityProtocol = SecurityProtocolType.Tls12 | SecurityProtocolType.Tls11 | SecurityProtocolType.Tls;

            _generator = RandomNumberGenerator.Create();

            var environment = "Staging";
            var basePath = "secret/backend/" + environment.ToLower() + "/";

            var secrets = new Dictionary<string, object>()
            {
                { "", "" },                                
            };



            // TODO: Populate secrets dictionary


            // Reading Secrets
            //var vals = new Dictionary<string, object>();
            //foreach (var secret in secrets)
            //{
            //    vals[secret.Key] = VaultSharpHelper.GetSecretValue(secret.Key, environment);
            //}

            // Writing Secrets
            foreach (var secret in secrets)
            {                
                VaultSharpHelper.WriteSecretValue(secret.Key, secret.Value, environment);
            }

            if (_generator != null)
            {
                _generator.Dispose();
            }
        }

        private static string GenerateRandomString(RandomNumberGenerator generator, int desiredLength)
        {
            if (desiredLength < 1 || desiredLength % 4 != 0)
            {
                throw new InvalidOperationException();
            }

            var key = new byte[desiredLength * 3 / 4];
            generator.GetBytes(key);
            return Convert.ToBase64String(key);
        }
    }


}

