import * as Curse_Friends_AccountsWebService_Contracts from './models/Curse.Friends.AccountsWebService.Contracts';
import * as Curse_Friends_Enums from './models/Curse.Friends.Enums';
import * as Curse_Friends_NotificationContracts from './models/Curse.Friends.NotificationContracts';

import { BaseWebServiceClient as base } from './lib/BaseWebServiceClient';
export class AccountApiService extends base {    

	accountRename(userID:number, renameRequest:Curse_Friends_AccountsWebService_Contracts.AccountRenameRequest):Promise<void> {
		return this._post<void>(`account/api/${userID}/rename`, renameRequest);
	}

	accountRenameForRegion(regionKey:string, userID:number, renameRequest:Curse_Friends_AccountsWebService_Contracts.AccountRenameRequest):Promise<void> {
		return this._postForRegion<void>(regionKey,`account/api/${userID}/rename`, renameRequest);
	}



}