import * as Curse_Friends_AccountsWebService_Contracts from './models/Curse.Friends.AccountsWebService.Contracts';
import * as Curse_Friends_Enums from './models/Curse.Friends.Enums';
import * as Curse_Friends_NotificationContracts from './models/Curse.Friends.NotificationContracts';

import { BaseWebServiceClient as base } from './lib/BaseWebServiceClient';
export class AccountService extends base {    

	getPushPreferences():Promise<Curse_Friends_AccountsWebService_Contracts.PushPreferencesResponse> {
		return this._get<Curse_Friends_AccountsWebService_Contracts.PushPreferencesResponse>(`account/preferences/push`);
	}

	getPushPreferencesForRegion(regionKey:string):Promise<Curse_Friends_AccountsWebService_Contracts.PushPreferencesResponse> {
		return this._getForRegion<Curse_Friends_AccountsWebService_Contracts.PushPreferencesResponse>(regionKey,`account/preferences/push`);
	}

	changePushPreferences(request:Curse_Friends_AccountsWebService_Contracts.PushNotificationPreferencesRequest):Promise<void> {
		return this._post<void>(`account/preferences/push`, request);
	}

	changePushPreferencesForRegion(regionKey:string, request:Curse_Friends_AccountsWebService_Contracts.PushNotificationPreferencesRequest):Promise<void> {
		return this._postForRegion<void>(regionKey,`account/preferences/push`, request);
	}

	getPrivacyPreferences():Promise<Curse_Friends_NotificationContracts.UserPrivacySettingsContract> {
		return this._get<Curse_Friends_NotificationContracts.UserPrivacySettingsContract>(`account/preferences/privacy`);
	}

	getPrivacyPreferencesForRegion(regionKey:string):Promise<Curse_Friends_NotificationContracts.UserPrivacySettingsContract> {
		return this._getForRegion<Curse_Friends_NotificationContracts.UserPrivacySettingsContract>(regionKey,`account/preferences/privacy`);
	}

	changePrivacyPreferences(request:Curse_Friends_NotificationContracts.UserPrivacySettingsContract):Promise<void> {
		return this._post<void>(`account/preferences/privacy`, request);
	}

	changePrivacyPreferencesForRegion(regionKey:string, request:Curse_Friends_NotificationContracts.UserPrivacySettingsContract):Promise<void> {
		return this._postForRegion<void>(regionKey,`account/preferences/privacy`, request);
	}

	setIdle(request:Curse_Friends_AccountsWebService_Contracts.SetIdleRequest):Promise<void> {
		return this._post<void>(`account/status/idle`, request);
	}

	setIdleForRegion(regionKey:string, request:Curse_Friends_AccountsWebService_Contracts.SetIdleRequest):Promise<void> {
		return this._postForRegion<void>(regionKey,`account/status/idle`, request);
	}

	setActive(request:Curse_Friends_AccountsWebService_Contracts.SetActiveRequest):Promise<void> {
		return this._post<void>(`account/status/active`, request);
	}

	setActiveForRegion(regionKey:string, request:Curse_Friends_AccountsWebService_Contracts.SetActiveRequest):Promise<void> {
		return this._postForRegion<void>(regionKey,`account/status/active`, request);
	}

	changeStatus(request:Curse_Friends_AccountsWebService_Contracts.ChangeStatusRequest):Promise<void> {
		return this._post<void>(`account/status/connection`, request);
	}

	changeStatusForRegion(regionKey:string, request:Curse_Friends_AccountsWebService_Contracts.ChangeStatusRequest):Promise<void> {
		return this._postForRegion<void>(regionKey,`account/status/connection`, request);
	}

	changeGameStatus(request:Curse_Friends_AccountsWebService_Contracts.ChangeGameStatusRequest):Promise<void> {
		return this._post<void>(`account/status/game`, request);
	}

	changeGameStatusForRegion(regionKey:string, request:Curse_Friends_AccountsWebService_Contracts.ChangeGameStatusRequest):Promise<void> {
		return this._postForRegion<void>(regionKey,`account/status/game`, request);
	}

	changeWatchingStatus(request:Curse_Friends_AccountsWebService_Contracts.ChangeWatchingStatusRequest):Promise<void> {
		return this._post<void>(`account/status/watching`, request);
	}

	changeWatchingStatusForRegion(regionKey:string, request:Curse_Friends_AccountsWebService_Contracts.ChangeWatchingStatusRequest):Promise<void> {
		return this._postForRegion<void>(regionKey,`account/status/watching`, request);
	}

	changeProfile(request:Curse_Friends_AccountsWebService_Contracts.ChangeProfileRequest):Promise<void> {
		return this._post<void>(`account/profile`, request);
	}

	changeProfileForRegion(regionKey:string, request:Curse_Friends_AccountsWebService_Contracts.ChangeProfileRequest):Promise<void> {
		return this._postForRegion<void>(regionKey,`account/profile`, request);
	}

	getProfile():Promise<Curse_Friends_NotificationContracts.UserProfileNotification> {
		return this._get<Curse_Friends_NotificationContracts.UserProfileNotification>(`account/profile`);
	}

	getProfileForRegion(regionKey:string):Promise<Curse_Friends_NotificationContracts.UserProfileNotification> {
		return this._getForRegion<Curse_Friends_NotificationContracts.UserProfileNotification>(regionKey,`account/profile`);
	}

	changePassword(request:Curse_Friends_AccountsWebService_Contracts.ChangePasswordRequest):Promise<Curse_Friends_AccountsWebService_Contracts.ChangePasswordStatus> {
		return this._post<Curse_Friends_AccountsWebService_Contracts.ChangePasswordStatus>(`account/password`, request);
	}

	changePasswordForRegion(regionKey:string, request:Curse_Friends_AccountsWebService_Contracts.ChangePasswordRequest):Promise<Curse_Friends_AccountsWebService_Contracts.ChangePasswordStatus> {
		return this._postForRegion<Curse_Friends_AccountsWebService_Contracts.ChangePasswordStatus>(regionKey,`account/password`, request);
	}

	changeEmail(request:Curse_Friends_AccountsWebService_Contracts.ChangeEmailRequest):Promise<Curse_Friends_AccountsWebService_Contracts.ChangeEmailStatus> {
		return this._post<Curse_Friends_AccountsWebService_Contracts.ChangeEmailStatus>(`account/email`, request);
	}

	changeEmailForRegion(regionKey:string, request:Curse_Friends_AccountsWebService_Contracts.ChangeEmailRequest):Promise<Curse_Friends_AccountsWebService_Contracts.ChangeEmailStatus> {
		return this._postForRegion<Curse_Friends_AccountsWebService_Contracts.ChangeEmailStatus>(regionKey,`account/email`, request);
	}

	getChangeUsernameAvailability():Promise<Curse_Friends_AccountsWebService_Contracts.GetChangeUsernameAvailabilityResponse> {
		return this._get<Curse_Friends_AccountsWebService_Contracts.GetChangeUsernameAvailabilityResponse>(`account/rename`);
	}

	getChangeUsernameAvailabilityForRegion(regionKey:string):Promise<Curse_Friends_AccountsWebService_Contracts.GetChangeUsernameAvailabilityResponse> {
		return this._getForRegion<Curse_Friends_AccountsWebService_Contracts.GetChangeUsernameAvailabilityResponse>(regionKey,`account/rename`);
	}

	changeUsername(request:Curse_Friends_AccountsWebService_Contracts.ChangeUsernameRequest):Promise<Curse_Friends_Enums.ChangeUsernameStatus> {
		return this._post<Curse_Friends_Enums.ChangeUsernameStatus>(`account/rename`, request);
	}

	changeUsernameForRegion(regionKey:string, request:Curse_Friends_AccountsWebService_Contracts.ChangeUsernameRequest):Promise<Curse_Friends_Enums.ChangeUsernameStatus> {
		return this._postForRegion<Curse_Friends_Enums.ChangeUsernameStatus>(regionKey,`account/rename`, request);
	}

	getClientSettings():Promise<Curse_Friends_NotificationContracts.UserClientSettingsNotification> {
		return this._get<Curse_Friends_NotificationContracts.UserClientSettingsNotification>(`account/preferences/client-settings`);
	}

	getClientSettingsForRegion(regionKey:string):Promise<Curse_Friends_NotificationContracts.UserClientSettingsNotification> {
		return this._getForRegion<Curse_Friends_NotificationContracts.UserClientSettingsNotification>(regionKey,`account/preferences/client-settings`);
	}

	changeClientSettings(request:Curse_Friends_AccountsWebService_Contracts.ChangeClientSettingsRequest):Promise<Curse_Friends_NotificationContracts.UserClientSettingsNotification> {
		return this._post<Curse_Friends_NotificationContracts.UserClientSettingsNotification>(`account/preferences/client-settings`, request);
	}

	changeClientSettingsForRegion(regionKey:string, request:Curse_Friends_AccountsWebService_Contracts.ChangeClientSettingsRequest):Promise<Curse_Friends_NotificationContracts.UserClientSettingsNotification> {
		return this._postForRegion<Curse_Friends_NotificationContracts.UserClientSettingsNotification>(regionKey,`account/preferences/client-settings`, request);
	}

	getAccountEntitlements():Promise<Curse_Friends_AccountsWebService_Contracts.AccountEntitlementsResponse> {
		return this._get<Curse_Friends_AccountsWebService_Contracts.AccountEntitlementsResponse>(`account/entitlements`);
	}

	getAccountEntitlementsForRegion(regionKey:string):Promise<Curse_Friends_AccountsWebService_Contracts.AccountEntitlementsResponse> {
		return this._getForRegion<Curse_Friends_AccountsWebService_Contracts.AccountEntitlementsResponse>(regionKey,`account/entitlements`);
	}

	getAllowedEmotes():Promise<Curse_Friends_AccountsWebService_Contracts.EmoteContract[]> {
		return this._get<Curse_Friends_AccountsWebService_Contracts.EmoteContract[]>(`account/emotes`);
	}

	getAllowedEmotesForRegion(regionKey:string):Promise<Curse_Friends_AccountsWebService_Contracts.EmoteContract[]> {
		return this._getForRegion<Curse_Friends_AccountsWebService_Contracts.EmoteContract[]>(regionKey,`account/emotes`);
	}

	getTwitchEmotes():Promise<Curse_Friends_AccountsWebService_Contracts.GetTwitchEmotesResponse> {
		return this._get<Curse_Friends_AccountsWebService_Contracts.GetTwitchEmotesResponse>(`account/twitch-emotes`);
	}

	getTwitchEmotesForRegion(regionKey:string):Promise<Curse_Friends_AccountsWebService_Contracts.GetTwitchEmotesResponse> {
		return this._getForRegion<Curse_Friends_AccountsWebService_Contracts.GetTwitchEmotesResponse>(regionKey,`account/twitch-emotes`);
	}

	getTwitchToken():Promise<Curse_Friends_AccountsWebService_Contracts.GetTwitchTokenResponse> {
		return this._get<Curse_Friends_AccountsWebService_Contracts.GetTwitchTokenResponse>(`account/twitch-token`);
	}

	getTwitchTokenForRegion(regionKey:string):Promise<Curse_Friends_AccountsWebService_Contracts.GetTwitchTokenResponse> {
		return this._getForRegion<Curse_Friends_AccountsWebService_Contracts.GetTwitchTokenResponse>(regionKey,`account/twitch-token`);
	}



}