import * as Curse_Friends_AvatarsWebService_Contract from './models/Curse.Friends.AvatarsWebService.Contract';
import * as Curse_Friends_Enums from './models/Curse.Friends.Enums';
import * as Curse_Friends_ImageManager from './models/Curse.Friends.ImageManager';
import * as Curse_Friends_MicroService_Contracts from './models/Curse.Friends.MicroService.Contracts';

import { BaseWebServiceClient as base } from './lib/BaseWebServiceClient';
export class AvatarAdminService extends base {    

	findUserAvatar(search:Curse_Friends_AvatarsWebService_Contract.FindUserAvatarSearchRequest):Promise<Curse_Friends_AvatarsWebService_Contract.FindUserAvatarSearchResult[]> {
		return this._post<Curse_Friends_AvatarsWebService_Contract.FindUserAvatarSearchResult[]>(`avatars/api/quarantine/users/search`, search);
	}

	findUserAvatarForRegion(regionKey:string, search:Curse_Friends_AvatarsWebService_Contract.FindUserAvatarSearchRequest):Promise<Curse_Friends_AvatarsWebService_Contract.FindUserAvatarSearchResult[]> {
		return this._postForRegion<Curse_Friends_AvatarsWebService_Contract.FindUserAvatarSearchResult[]>(regionKey,`avatars/api/quarantine/users/search`, search);
	}

	markAvatarAsInappropriate(request:Curse_Friends_AvatarsWebService_Contract.MarkAvatarInappropriateRequest):Promise<void> {
		return this._post<void>(`avatars/api/quarantine/users`, request);
	}

	markAvatarAsInappropriateForRegion(regionKey:string, request:Curse_Friends_AvatarsWebService_Contract.MarkAvatarInappropriateRequest):Promise<void> {
		return this._postForRegion<void>(regionKey,`avatars/api/quarantine/users`, request);
	}

	unmarkAvatarAsInappropriate(userID:number):Promise<void> {
		return this._delete<void>(`avatars/api/quarantine/users/${userID}`);
	}

	unmarkAvatarAsInappropriateForRegion(regionKey:string, userID:number):Promise<void> {
		return this._deleteForRegion<void>(regionKey,`avatars/api/quarantine/users/${userID}`);
	}

	getAvatar(entityID:string):Promise<Curse_Friends_AvatarsWebService_Contract.GetAvatarResult[]> {
		return this._get<Curse_Friends_AvatarsWebService_Contract.GetAvatarResult[]>(`avatars/api/${entityID}`);
	}

	getAvatarForRegion(regionKey:string, entityID:string):Promise<Curse_Friends_AvatarsWebService_Contract.GetAvatarResult[]> {
		return this._getForRegion<Curse_Friends_AvatarsWebService_Contract.GetAvatarResult[]>(regionKey,`avatars/api/${entityID}`);
	}

	purgeAvatar(type:Curse_Friends_Enums.AvatarType, entityID:string):Promise<void> {
		return this._delete<void>(`avatars/api/${type}/${entityID}`);
	}

	purgeAvatarForRegion(regionKey:string, type:Curse_Friends_Enums.AvatarType, entityID:string):Promise<void> {
		return this._deleteForRegion<void>(regionKey,`avatars/api/${type}/${entityID}`);
	}

	changeAvatarBase64(type:Curse_Friends_Enums.AvatarType, entityID:string, value:string):Promise<Curse_Friends_ImageManager.ImageMetadata> {
		return this._post<Curse_Friends_ImageManager.ImageMetadata>(`avatars/api/${type}/${entityID}/base64`, value);
	}

	changeAvatarBase64ForRegion(regionKey:string, type:Curse_Friends_Enums.AvatarType, entityID:string, value:string):Promise<Curse_Friends_ImageManager.ImageMetadata> {
		return this._postForRegion<Curse_Friends_ImageManager.ImageMetadata>(regionKey,`avatars/api/${type}/${entityID}/base64`, value);
	}

	changeAvatarUrl(type:Curse_Friends_Enums.AvatarType, entityID:string, url:string):Promise<void> {
		return this._post<void>(`avatars/api/${type}/${entityID}/url`, url);
	}

	changeAvatarUrlForRegion(regionKey:string, type:Curse_Friends_Enums.AvatarType, entityID:string, url:string):Promise<void> {
		return this._postForRegion<void>(regionKey,`avatars/api/${type}/${entityID}/url`, url);
	}



}