import * as Curse_Friends_BugsWebService_Contracts from './models/Curse.Friends.BugsWebService.Contracts';
import * as Curse_Friends_Enums from './models/Curse.Friends.Enums';

import { BaseWebServiceClient as base } from './lib/BaseWebServiceClient';
export class BugsApiService extends base {    

	getReportAttachments(bugReportID:number):Promise<Curse_Friends_BugsWebService_Contracts.ClientBugReportAttachmentContract[]> {
		return this._get<Curse_Friends_BugsWebService_Contracts.ClientBugReportAttachmentContract[]>(`bugs/api/reports/${bugReportID}/attachments`);
	}

	getReportAttachmentsForRegion(regionKey:string, bugReportID:number):Promise<Curse_Friends_BugsWebService_Contracts.ClientBugReportAttachmentContract[]> {
		return this._getForRegion<Curse_Friends_BugsWebService_Contracts.ClientBugReportAttachmentContract[]>(regionKey,`bugs/api/reports/${bugReportID}/attachments`);
	}



}