import * as Curse_Friends_CallsWebService_Contracts from './models/Curse.Friends.CallsWebService.Contracts';
import * as Curse_Friends_NotificationContracts from './models/Curse.Friends.NotificationContracts';
import * as Curse_Friends_Enums from './models/Curse.Friends.Enums';

import { BaseWebServiceClient as base } from './lib/BaseWebServiceClient';
export class CallsAdminService extends base {    

	voiceHostCallback(request:Curse_Friends_CallsWebService_Contracts.VoiceHostCallbackRequest):Promise<void> {
		return this._post<void>(`calls/api/host-callback`, request);
	}

	voiceHostCallbackForRegion(regionKey:string, request:Curse_Friends_CallsWebService_Contracts.VoiceHostCallbackRequest):Promise<void> {
		return this._postForRegion<void>(regionKey,`calls/api/host-callback`, request);
	}

	kickUsersFromCall(request:Curse_Friends_CallsWebService_Contracts.KickUsersFromCallRequest):Promise<void> {
		return this._post<void>(`calls/api/kick`, request);
	}

	kickUsersFromCallForRegion(regionKey:string, request:Curse_Friends_CallsWebService_Contracts.KickUsersFromCallRequest):Promise<void> {
		return this._postForRegion<void>(regionKey,`calls/api/kick`, request);
	}

	checkMuteUserPermission(request:Curse_Friends_CallsWebService_Contracts.CheckVoicePermissionsRequest):Promise<void> {
		return this._post<void>(`calls/api/check-permissions/mute`, request);
	}

	checkMuteUserPermissionForRegion(regionKey:string, request:Curse_Friends_CallsWebService_Contracts.CheckVoicePermissionsRequest):Promise<void> {
		return this._postForRegion<void>(regionKey,`calls/api/check-permissions/mute`, request);
	}

	checkDeafenUserPermission(request:Curse_Friends_CallsWebService_Contracts.CheckVoicePermissionsRequest):Promise<void> {
		return this._post<void>(`calls/api/check-permissions/deafen`, request);
	}

	checkDeafenUserPermissionForRegion(regionKey:string, request:Curse_Friends_CallsWebService_Contracts.CheckVoicePermissionsRequest):Promise<void> {
		return this._postForRegion<void>(regionKey,`calls/api/check-permissions/deafen`, request);
	}

	checkKickUserPermission(request:Curse_Friends_CallsWebService_Contracts.CheckVoicePermissionsRequest):Promise<void> {
		return this._post<void>(`calls/api/check-permissions/kick`, request);
	}

	checkKickUserPermissionForRegion(regionKey:string, request:Curse_Friends_CallsWebService_Contracts.CheckVoicePermissionsRequest):Promise<void> {
		return this._postForRegion<void>(regionKey,`calls/api/check-permissions/kick`, request);
	}

	getModerationStatus(groupID:string, userID:number):Promise<Curse_Friends_CallsWebService_Contracts.GetModerationStatusResponse> {
		return this._get<Curse_Friends_CallsWebService_Contracts.GetModerationStatusResponse>(`calls/api/moderation-status/${groupID}/${userID}`);
	}

	getModerationStatusForRegion(regionKey:string, groupID:string, userID:number):Promise<Curse_Friends_CallsWebService_Contracts.GetModerationStatusResponse> {
		return this._getForRegion<Curse_Friends_CallsWebService_Contracts.GetModerationStatusResponse>(regionKey,`calls/api/moderation-status/${groupID}/${userID}`);
	}



}