import * as Curse_Friends_CallsWebService_Contracts from './models/Curse.Friends.CallsWebService.Contracts';
import * as Curse_Friends_NotificationContracts from './models/Curse.Friends.NotificationContracts';
import * as Curse_Friends_Enums from './models/Curse.Friends.Enums';

import { BaseWebServiceClient as base } from './lib/BaseWebServiceClient';
export class CallsService extends base {    

	conversation(conversationID:string, request:Curse_Friends_CallsWebService_Contracts.ConversationCallRequest):Promise<Curse_Friends_NotificationContracts.CallNotification> {
		return this._post<Curse_Friends_NotificationContracts.CallNotification>(`calls/conversations/${conversationID}`, request);
	}

	conversationForRegion(regionKey:string, conversationID:string, request:Curse_Friends_CallsWebService_Contracts.ConversationCallRequest):Promise<Curse_Friends_NotificationContracts.CallNotification> {
		return this._postForRegion<Curse_Friends_NotificationContracts.CallNotification>(regionKey,`calls/conversations/${conversationID}`, request);
	}

	adHoc(request:Curse_Friends_CallsWebService_Contracts.AdHocCallRequest):Promise<Curse_Friends_NotificationContracts.CallNotification> {
		return this._post<Curse_Friends_NotificationContracts.CallNotification>(`calls/adhoc`, request);
	}

	adHocForRegion(regionKey:string, request:Curse_Friends_CallsWebService_Contracts.AdHocCallRequest):Promise<Curse_Friends_NotificationContracts.CallNotification> {
		return this._postForRegion<Curse_Friends_NotificationContracts.CallNotification>(regionKey,`calls/adhoc`, request);
	}

	autoMatch(request:Curse_Friends_CallsWebService_Contracts.AutoMatchCallRequest):Promise<Curse_Friends_NotificationContracts.CallNotification> {
		return this._post<Curse_Friends_NotificationContracts.CallNotification>(`calls/automatch`, request);
	}

	autoMatchForRegion(regionKey:string, request:Curse_Friends_CallsWebService_Contracts.AutoMatchCallRequest):Promise<Curse_Friends_NotificationContracts.CallNotification> {
		return this._postForRegion<Curse_Friends_NotificationContracts.CallNotification>(regionKey,`calls/automatch`, request);
	}

	adHocDetails(inviteCode:string):Promise<Curse_Friends_NotificationContracts.CallNotification> {
		return this._get<Curse_Friends_NotificationContracts.CallNotification>(`calls/adhoc/${inviteCode}`);
	}

	adHocDetailsForRegion(regionKey:string, inviteCode:string):Promise<Curse_Friends_NotificationContracts.CallNotification> {
		return this._getForRegion<Curse_Friends_NotificationContracts.CallNotification>(regionKey,`calls/adhoc/${inviteCode}`);
	}

	adHocDisplayDetails(inviteCode:string):Promise<Curse_Friends_CallsWebService_Contracts.AdHocCallDisplayDetailsResponse> {
		return this._get<Curse_Friends_CallsWebService_Contracts.AdHocCallDisplayDetailsResponse>(`calls/adhoc/${inviteCode}/display`);
	}

	adHocDisplayDetailsForRegion(regionKey:string, inviteCode:string):Promise<Curse_Friends_CallsWebService_Contracts.AdHocCallDisplayDetailsResponse> {
		return this._getForRegion<Curse_Friends_CallsWebService_Contracts.AdHocCallDisplayDetailsResponse>(regionKey,`calls/adhoc/${inviteCode}/display`);
	}

	addFriendToCall(callID:string, friendID:number):Promise<void> {
		return this._post<void>(`calls/${callID}/invite`, friendID);
	}

	addFriendToCallForRegion(regionKey:string, callID:string, friendID:number):Promise<void> {
		return this._postForRegion<void>(regionKey,`calls/${callID}/invite`, friendID);
	}

	decline(callID:string):Promise<void> {
		return this._post<void>(`calls/${callID}/decline`);
	}

	declineForRegion(regionKey:string, callID:string):Promise<void> {
		return this._postForRegion<void>(regionKey,`calls/${callID}/decline`);
	}

	accept(callID:string):Promise<void> {
		return this._post<void>(`calls/${callID}/accept`);
	}

	acceptForRegion(regionKey:string, callID:string):Promise<void> {
		return this._postForRegion<void>(regionKey,`calls/${callID}/accept`);
	}

	unlock(callID:string):Promise<void> {
		return this._post<void>(`calls/${callID}/unlock`);
	}

	unlockForRegion(regionKey:string, callID:string):Promise<void> {
		return this._postForRegion<void>(regionKey,`calls/${callID}/unlock`);
	}

	enableVideo(callID:string):Promise<void> {
		return this._post<void>(`calls/${callID}/enable-video`);
	}

	enableVideoForRegion(regionKey:string, callID:string):Promise<void> {
		return this._postForRegion<void>(regionKey,`calls/${callID}/enable-video`);
	}

	muteUser(conversationID:string, userID:number):Promise<void> {
		return this._post<void>(`calls/${conversationID}/moderation/muted-users`, userID);
	}

	muteUserForRegion(regionKey:string, conversationID:string, userID:number):Promise<void> {
		return this._postForRegion<void>(regionKey,`calls/${conversationID}/moderation/muted-users`, userID);
	}

	unmuteUser(conversationID:string, userID:number):Promise<void> {
		return this._delete<void>(`calls/${conversationID}/moderation/muted-users/${userID}`);
	}

	unmuteUserForRegion(regionKey:string, conversationID:string, userID:number):Promise<void> {
		return this._deleteForRegion<void>(regionKey,`calls/${conversationID}/moderation/muted-users/${userID}`);
	}

	deafenUser(conversationID:string, request:Curse_Friends_CallsWebService_Contracts.DeafenUserRequest):Promise<void> {
		return this._post<void>(`calls/${conversationID}/moderation/deafened-users`, request);
	}

	deafenUserForRegion(regionKey:string, conversationID:string, request:Curse_Friends_CallsWebService_Contracts.DeafenUserRequest):Promise<void> {
		return this._postForRegion<void>(regionKey,`calls/${conversationID}/moderation/deafened-users`, request);
	}

	undeafenUser(conversationID:string, userID:number, unmute:boolean):Promise<void> {
		return this._delete<void>(`calls/${conversationID}/moderation/deafened-users/${userID}?unmute=${unmute}`);
	}

	undeafenUserForRegion(regionKey:string, conversationID:string, userID:number, unmute:boolean):Promise<void> {
		return this._deleteForRegion<void>(regionKey,`calls/${conversationID}/moderation/deafened-users/${userID}?unmute=${unmute}`);
	}

	kickUser(conversationID:string, userID:number):Promise<void> {
		return this._delete<void>(`calls/${conversationID}/moderation/${userID}`);
	}

	kickUserForRegion(regionKey:string, conversationID:string, userID:number):Promise<void> {
		return this._deleteForRegion<void>(regionKey,`calls/${conversationID}/moderation/${userID}`);
	}

	moveUser(groupID:string, userID:number, request:Curse_Friends_CallsWebService_Contracts.MoveUserRequest):Promise<void> {
		return this._post<void>(`calls/${groupID}/moderation/${userID}/move`, request);
	}

	moveUserForRegion(regionKey:string, groupID:string, userID:number, request:Curse_Friends_CallsWebService_Contracts.MoveUserRequest):Promise<void> {
		return this._postForRegion<void>(regionKey,`calls/${groupID}/moderation/${userID}/move`, request);
	}



}