import * as Curse_Friends_NotificationContracts from './models/Curse.Friends.NotificationContracts';
import * as Curse_Friends_Enums from './models/Curse.Friends.Enums';
import * as Curse_Friends_ContactsWebService_Contracts from './models/Curse.Friends.ContactsWebService.Contracts';

import { BaseWebServiceClient as base } from './lib/BaseWebServiceClient';
export class ContactsService extends base {    

	getAll():Promise<Curse_Friends_ContactsWebService_Contracts.ContactsResponse> {
		return this._get<Curse_Friends_ContactsWebService_Contracts.ContactsResponse>(`contacts`);
	}

	getAllForRegion(regionKey:string):Promise<Curse_Friends_ContactsWebService_Contracts.ContactsResponse> {
		return this._getForRegion<Curse_Friends_ContactsWebService_Contracts.ContactsResponse>(regionKey,`contacts`);
	}

	getRecent(timestamp:number):Promise<Curse_Friends_ContactsWebService_Contracts.ContactsResponse> {
		return this._get<Curse_Friends_ContactsWebService_Contracts.ContactsResponse>(`contacts/recent/${timestamp}`);
	}

	getRecentForRegion(regionKey:string, timestamp:number):Promise<Curse_Friends_ContactsWebService_Contracts.ContactsResponse> {
		return this._getForRegion<Curse_Friends_ContactsWebService_Contracts.ContactsResponse>(regionKey,`contacts/recent/${timestamp}`);
	}

	getByUrl(url:string):Promise<Curse_Friends_ContactsWebService_Contracts.ContactUrlResponse> {
		return this._post<Curse_Friends_ContactsWebService_Contracts.ContactUrlResponse>(`contacts/url`, url);
	}

	getByUrlForRegion(regionKey:string, url:string):Promise<Curse_Friends_ContactsWebService_Contracts.ContactUrlResponse> {
		return this._postForRegion<Curse_Friends_ContactsWebService_Contracts.ContactUrlResponse>(regionKey,`contacts/url`, url);
	}



}