import * as Curse_Friends_NotificationContracts from './models/Curse.Friends.NotificationContracts';
import * as Curse_Friends_Enums from './models/Curse.Friends.Enums';
import * as Curse_Friends_ConversationsWebService_Contracts from './models/Curse.Friends.ConversationsWebService.Contracts';

import { BaseWebServiceClient as base } from './lib/BaseWebServiceClient';
export class ConversationsService extends base {    

	history(id:string, endTimestamp:number, pageSize:number, startTimestamp:number):Promise<Curse_Friends_NotificationContracts.ConversationMessageNotification[]> {
		return this._get<Curse_Friends_NotificationContracts.ConversationMessageNotification[]>(`conversations/${id}?endTimestamp=${endTimestamp}&pageSize=${pageSize}&startTimestamp=${startTimestamp}`);
	}

	historyForRegion(regionKey:string, id:string, endTimestamp:number, pageSize:number, startTimestamp:number):Promise<Curse_Friends_NotificationContracts.ConversationMessageNotification[]> {
		return this._getForRegion<Curse_Friends_NotificationContracts.ConversationMessageNotification[]>(regionKey,`conversations/${id}?endTimestamp=${endTimestamp}&pageSize=${pageSize}&startTimestamp=${startTimestamp}`);
	}

	jump(id:string, timestamp:number, pageSizeBefore:number, pageSizeAfter:number):Promise<Curse_Friends_NotificationContracts.ConversationMessageNotification[]> {
		return this._get<Curse_Friends_NotificationContracts.ConversationMessageNotification[]>(`conversations/${id}/jump?timestamp=${timestamp}&pageSizeBefore=${pageSizeBefore}&pageSizeAfter=${pageSizeAfter}`);
	}

	jumpForRegion(regionKey:string, id:string, timestamp:number, pageSizeBefore:number, pageSizeAfter:number):Promise<Curse_Friends_NotificationContracts.ConversationMessageNotification[]> {
		return this._getForRegion<Curse_Friends_NotificationContracts.ConversationMessageNotification[]>(regionKey,`conversations/${id}/jump?timestamp=${timestamp}&pageSizeBefore=${pageSizeBefore}&pageSizeAfter=${pageSizeAfter}`);
	}

	editAttachment(conversationID:string, attachmentID:string, request:Curse_Friends_ConversationsWebService_Contracts.ConversationAttachmentEditRequest):Promise<void> {
		return this._post<void>(`conversations/${conversationID}/attachments/${attachmentID}`, request);
	}

	editAttachmentForRegion(regionKey:string, conversationID:string, attachmentID:string, request:Curse_Friends_ConversationsWebService_Contracts.ConversationAttachmentEditRequest):Promise<void> {
		return this._postForRegion<void>(regionKey,`conversations/${conversationID}/attachments/${attachmentID}`, request);
	}

	deleteAttachment(conversationID:string, attachmentID:string, request:Curse_Friends_ConversationsWebService_Contracts.ConversationDeleteAttachmentRequest):Promise<void> {
		return this._delete<void>(`conversations/${conversationID}/attachments/${attachmentID}`, request);
	}

	deleteAttachmentForRegion(regionKey:string, conversationID:string, attachmentID:string, request:Curse_Friends_ConversationsWebService_Contracts.ConversationDeleteAttachmentRequest):Promise<void> {
		return this._deleteForRegion<void>(regionKey,`conversations/${conversationID}/attachments/${attachmentID}`, request);
	}

	search(conversationID:string, searchFilters:Curse_Friends_ConversationsWebService_Contracts.ConversationSearchRequest):Promise<Curse_Friends_ConversationsWebService_Contracts.ConversationSearchItem[]> {
		return this._post<Curse_Friends_ConversationsWebService_Contracts.ConversationSearchItem[]>(`conversations/${conversationID}/search`, searchFilters);
	}

	searchForRegion(regionKey:string, conversationID:string, searchFilters:Curse_Friends_ConversationsWebService_Contracts.ConversationSearchRequest):Promise<Curse_Friends_ConversationsWebService_Contracts.ConversationSearchItem[]> {
		return this._postForRegion<Curse_Friends_ConversationsWebService_Contracts.ConversationSearchItem[]>(regionKey,`conversations/${conversationID}/search`, searchFilters);
	}

	hide(conversationID:string):Promise<void> {
		return this._post<void>(`conversations/${conversationID}/hide`);
	}

	hideForRegion(regionKey:string, conversationID:string):Promise<void> {
		return this._postForRegion<void>(regionKey,`conversations/${conversationID}/hide`);
	}

	unhide(conversationID:string):Promise<void> {
		return this._post<void>(`conversations/${conversationID}/unhide`);
	}

	unhideForRegion(regionKey:string, conversationID:string):Promise<void> {
		return this._postForRegion<void>(regionKey,`conversations/${conversationID}/unhide`);
	}

	mute(conversationID:string):Promise<void> {
		return this._post<void>(`conversations/${conversationID}/mute`);
	}

	muteForRegion(regionKey:string, conversationID:string):Promise<void> {
		return this._postForRegion<void>(regionKey,`conversations/${conversationID}/mute`);
	}

	unmute(conversationID:string):Promise<void> {
		return this._post<void>(`conversations/${conversationID}/unmute`);
	}

	unmuteForRegion(regionKey:string, conversationID:string):Promise<void> {
		return this._postForRegion<void>(regionKey,`conversations/${conversationID}/unmute`);
	}

	createMessage(conversationID:string, request:Curse_Friends_ConversationsWebService_Contracts.ConversationCreateMessageRequest):Promise<void> {
		return this._post<void>(`conversations/${conversationID}`, request);
	}

	createMessageForRegion(regionKey:string, conversationID:string, request:Curse_Friends_ConversationsWebService_Contracts.ConversationCreateMessageRequest):Promise<void> {
		return this._postForRegion<void>(regionKey,`conversations/${conversationID}`, request);
	}

	sendTwitchWhisper(twitchID:string, request:Curse_Friends_ConversationsWebService_Contracts.ConversationCreateMessageRequest):Promise<void> {
		return this._post<void>(`conversations/twitch/${twitchID}`, request);
	}

	sendTwitchWhisperForRegion(regionKey:string, twitchID:string, request:Curse_Friends_ConversationsWebService_Contracts.ConversationCreateMessageRequest):Promise<void> {
		return this._postForRegion<void>(regionKey,`conversations/twitch/${twitchID}`, request);
	}

	editMessage(conversationID:string, id:string, timestamp:number, request:Curse_Friends_ConversationsWebService_Contracts.ConversationEditMessageRequest):Promise<void> {
		return this._post<void>(`conversations/${conversationID}/${id}-${timestamp}`, request);
	}

	editMessageForRegion(regionKey:string, conversationID:string, id:string, timestamp:number, request:Curse_Friends_ConversationsWebService_Contracts.ConversationEditMessageRequest):Promise<void> {
		return this._postForRegion<void>(regionKey,`conversations/${conversationID}/${id}-${timestamp}`, request);
	}

	deleteMessage(conversationID:string, id:string, timestamp:number):Promise<void> {
		return this._delete<void>(`conversations/${conversationID}/${id}-${timestamp}`);
	}

	deleteMessageForRegion(regionKey:string, conversationID:string, id:string, timestamp:number):Promise<void> {
		return this._deleteForRegion<void>(regionKey,`conversations/${conversationID}/${id}-${timestamp}`);
	}

	likeMessage(conversationID:string, id:string, timestamp:number):Promise<void> {
		return this._post<void>(`conversations/${conversationID}/${id}-${timestamp}/like`);
	}

	likeMessageForRegion(regionKey:string, conversationID:string, id:string, timestamp:number):Promise<void> {
		return this._postForRegion<void>(regionKey,`conversations/${conversationID}/${id}-${timestamp}/like`);
	}

	unlikeMessage(conversationID:string, id:string, timestamp:number):Promise<void> {
		return this._post<void>(`conversations/${conversationID}/${id}-${timestamp}/unlike`);
	}

	unlikeMessageForRegion(regionKey:string, conversationID:string, id:string, timestamp:number):Promise<void> {
		return this._postForRegion<void>(regionKey,`conversations/${conversationID}/${id}-${timestamp}/unlike`);
	}

	markAsRead(conversationID:string, request:Curse_Friends_ConversationsWebService_Contracts.ConversationMarkReadRequest):Promise<void> {
		return this._post<void>(`conversations/${conversationID}/mark-as-read`, request);
	}

	markAsReadForRegion(regionKey:string, conversationID:string, request:Curse_Friends_ConversationsWebService_Contracts.ConversationMarkReadRequest):Promise<void> {
		return this._postForRegion<void>(regionKey,`conversations/${conversationID}/mark-as-read`, request);
	}

	markAllAsRead():Promise<void> {
		return this._post<void>(`conversations/mark-all-as-read`);
	}

	markAllAsReadForRegion(regionKey:string):Promise<void> {
		return this._postForRegion<void>(regionKey,`conversations/mark-all-as-read`);
	}

	flagAsSpam(conversationID:string, request:Curse_Friends_ConversationsWebService_Contracts.ConversationFlagSpamRequest):Promise<void> {
		return this._post<void>(`conversations/${conversationID}/flag-as-spam`, request);
	}

	flagAsSpamForRegion(regionKey:string, conversationID:string, request:Curse_Friends_ConversationsWebService_Contracts.ConversationFlagSpamRequest):Promise<void> {
		return this._postForRegion<void>(regionKey,`conversations/${conversationID}/flag-as-spam`, request);
	}



}