import * as Curse_Friends_NotificationContracts from './models/Curse.Friends.NotificationContracts';
import * as Curse_Friends_Enums from './models/Curse.Friends.Enums';
import * as Curse_Friends_ContactsWebService_Contracts from './models/Curse.Friends.ContactsWebService.Contracts';

import { BaseWebServiceClient as base } from './lib/BaseWebServiceClient';
export class FriendSuggestionsService extends base {    

	getAll():Promise<Curse_Friends_NotificationContracts.FriendSuggestionContract[]> {
		return this._get<Curse_Friends_NotificationContracts.FriendSuggestionContract[]>(`friend-suggestions`);
	}

	getAllForRegion(regionKey:string):Promise<Curse_Friends_NotificationContracts.FriendSuggestionContract[]> {
		return this._getForRegion<Curse_Friends_NotificationContracts.FriendSuggestionContract[]>(regionKey,`friend-suggestions`);
	}

	decline(friendID:number):Promise<void> {
		return this._delete<void>(`friend-suggestions/${friendID}`);
	}

	declineForRegion(regionKey:string, friendID:number):Promise<void> {
		return this._deleteForRegion<void>(regionKey,`friend-suggestions/${friendID}`);
	}



}