import * as Curse_Friends_NotificationContracts from './models/Curse.Friends.NotificationContracts';
import * as Curse_Friends_Enums from './models/Curse.Friends.Enums';
import * as Curse_Friends_ContactsWebService_Contracts from './models/Curse.Friends.ContactsWebService.Contracts';

import { BaseWebServiceClient as base } from './lib/BaseWebServiceClient';
export class FriendSyncService extends base {    

	upload(identities:Curse_Friends_NotificationContracts.FriendHintContract[]):Promise<void> {
		return this._post<void>(`friend-sync`, identities);
	}

	uploadForRegion(regionKey:string, identities:Curse_Friends_NotificationContracts.FriendHintContract[]):Promise<void> {
		return this._postForRegion<void>(regionKey,`friend-sync`, identities);
	}

	get():Promise<Curse_Friends_NotificationContracts.FriendHintContract[]> {
		return this._get<Curse_Friends_NotificationContracts.FriendHintContract[]>(`friend-sync`);
	}

	getForRegion(regionKey:string):Promise<Curse_Friends_NotificationContracts.FriendHintContract[]> {
		return this._getForRegion<Curse_Friends_NotificationContracts.FriendHintContract[]>(regionKey,`friend-sync`);
	}

	delete(id:number):Promise<void> {
		return this._delete<void>(`friend-sync/${id}`);
	}

	deleteForRegion(regionKey:string, id:number):Promise<void> {
		return this._deleteForRegion<void>(regionKey,`friend-sync/${id}`);
	}

	search(request:Curse_Friends_ContactsWebService_Contracts.FriendListSearchRequest):Promise<void> {
		return this._post<void>(`friend-sync/search`, request);
	}

	searchForRegion(regionKey:string, request:Curse_Friends_ContactsWebService_Contracts.FriendListSearchRequest):Promise<void> {
		return this._postForRegion<void>(regionKey,`friend-sync/search`, request);
	}

	multiSearch(request:Curse_Friends_ContactsWebService_Contracts.FriendListMultiSearchRequest):Promise<void> {
		return this._post<void>(`friend-sync/multi-search`, request);
	}

	multiSearchForRegion(regionKey:string, request:Curse_Friends_ContactsWebService_Contracts.FriendListMultiSearchRequest):Promise<void> {
		return this._postForRegion<void>(regionKey,`friend-sync/multi-search`, request);
	}



}