import * as Curse_Friends_NotificationContracts from './models/Curse.Friends.NotificationContracts';
import * as Curse_Friends_Enums from './models/Curse.Friends.Enums';
import * as Curse_Friends_ContactsWebService_Contracts from './models/Curse.Friends.ContactsWebService.Contracts';

import { BaseWebServiceClient as base } from './lib/BaseWebServiceClient';
export class FriendshipsService extends base {    

	get(friendID:number):Promise<Curse_Friends_NotificationContracts.FriendshipContract> {
		return this._get<Curse_Friends_NotificationContracts.FriendshipContract>(`friendship/${friendID}`);
	}

	getForRegion(regionKey:string, friendID:number):Promise<Curse_Friends_NotificationContracts.FriendshipContract> {
		return this._getForRegion<Curse_Friends_NotificationContracts.FriendshipContract>(regionKey,`friendship/${friendID}`);
	}

	confirm(friendID:number):Promise<void> {
		return this._post<void>(`friendship/${friendID}/confirm`);
	}

	confirmForRegion(regionKey:string, friendID:number):Promise<void> {
		return this._postForRegion<void>(regionKey,`friendship/${friendID}/confirm`);
	}

	decline(friendID:number):Promise<void> {
		return this._delete<void>(`friendship/${friendID}/decline`);
	}

	declineForRegion(regionKey:string, friendID:number):Promise<void> {
		return this._deleteForRegion<void>(regionKey,`friendship/${friendID}/decline`);
	}

	createTwitchFriend(twitchID:string, request:Curse_Friends_ContactsWebService_Contracts.FriendshipRequest):Promise<void> {
		return this._post<void>(`friendship/twitch/${twitchID}/create`, request);
	}

	createTwitchFriendForRegion(regionKey:string, twitchID:string, request:Curse_Friends_ContactsWebService_Contracts.FriendshipRequest):Promise<void> {
		return this._postForRegion<void>(regionKey,`friendship/twitch/${twitchID}/create`, request);
	}

	create(friendID:number, request:Curse_Friends_ContactsWebService_Contracts.FriendshipRequest):Promise<void> {
		return this._post<void>(`friendship/${friendID}/create`, request);
	}

	createForRegion(regionKey:string, friendID:number, request:Curse_Friends_ContactsWebService_Contracts.FriendshipRequest):Promise<void> {
		return this._postForRegion<void>(regionKey,`friendship/${friendID}/create`, request);
	}

	unfriend(friendID:number):Promise<void> {
		return this._delete<void>(`friendship/${friendID}/unfriend`);
	}

	unfriendForRegion(regionKey:string, friendID:number):Promise<void> {
		return this._deleteForRegion<void>(regionKey,`friendship/${friendID}/unfriend`);
	}

	favorite(friendID:number):Promise<void> {
		return this._post<void>(`friendship/${friendID}/favorite`);
	}

	favoriteForRegion(regionKey:string, friendID:number):Promise<void> {
		return this._postForRegion<void>(regionKey,`friendship/${friendID}/favorite`);
	}

	unfavorite(friendID:number):Promise<void> {
		return this._post<void>(`friendship/${friendID}/unfavorite`);
	}

	unfavoriteForRegion(regionKey:string, friendID:number):Promise<void> {
		return this._postForRegion<void>(regionKey,`friendship/${friendID}/unfavorite`);
	}

	getFriendsOfFriend(friendID:number):Promise<Curse_Friends_ContactsWebService_Contracts.FriendOfFriendDetails[]> {
		return this._get<Curse_Friends_ContactsWebService_Contracts.FriendOfFriendDetails[]>(`friendship/${friendID}/friends`);
	}

	getFriendsOfFriendForRegion(regionKey:string, friendID:number):Promise<Curse_Friends_ContactsWebService_Contracts.FriendOfFriendDetails[]> {
		return this._getForRegion<Curse_Friends_ContactsWebService_Contracts.FriendOfFriendDetails[]>(regionKey,`friendship/${friendID}/friends`);
	}

	renameFriend(friendID:number, nickname:string):Promise<void> {
		return this._post<void>(`friendship/${friendID}/rename`, nickname);
	}

	renameFriendForRegion(regionKey:string, friendID:number, nickname:string):Promise<void> {
		return this._postForRegion<void>(regionKey,`friendship/${friendID}/rename`, nickname);
	}

	search(query:string):Promise<Curse_Friends_ContactsWebService_Contracts.FriendSearchResponse> {
		return this._get<Curse_Friends_ContactsWebService_Contracts.FriendSearchResponse>(`friendship/search?query=${encodeURIComponent(query)}`);
	}

	searchForRegion(regionKey:string, query:string):Promise<Curse_Friends_ContactsWebService_Contracts.FriendSearchResponse> {
		return this._getForRegion<Curse_Friends_ContactsWebService_Contracts.FriendSearchResponse>(regionKey,`friendship/search?query=${encodeURIComponent(query)}`);
	}

	changeFriendNotificationPreferences(friendID:number, request:Curse_Friends_ContactsWebService_Contracts.ChangeFriendshipPreferencesRequest):Promise<void> {
		return this._post<void>(`friendship/${friendID}/preferences`, request);
	}

	changeFriendNotificationPreferencesForRegion(regionKey:string, friendID:number, request:Curse_Friends_ContactsWebService_Contracts.ChangeFriendshipPreferencesRequest):Promise<void> {
		return this._postForRegion<void>(regionKey,`friendship/${friendID}/preferences`, request);
	}



}