import * as Curse_Friends_GiveawaysWebService_Contracts from './models/Curse.Friends.GiveawaysWebService.Contracts';
import * as Curse_Friends_NotificationContracts from './models/Curse.Friends.NotificationContracts';
import * as Curse_Friends_Enums from './models/Curse.Friends.Enums';

import { BaseWebServiceClient as base } from './lib/BaseWebServiceClient';
export class GiveawaysService extends base {    

	getMyActiveClaimWindows():Promise<Curse_Friends_GiveawaysWebService_Contracts.ActiveGiveawayResponse[]> {
		return this._get<Curse_Friends_GiveawaysWebService_Contracts.ActiveGiveawayResponse[]>(`giveaways/pending-claims`);
	}

	getMyActiveClaimWindowsForRegion(regionKey:string):Promise<Curse_Friends_GiveawaysWebService_Contracts.ActiveGiveawayResponse[]> {
		return this._getForRegion<Curse_Friends_GiveawaysWebService_Contracts.ActiveGiveawayResponse[]>(regionKey,`giveaways/pending-claims`);
	}

	getActive(groupID:string):Promise<Curse_Friends_GiveawaysWebService_Contracts.ActiveGiveawayResponse> {
		return this._get<Curse_Friends_GiveawaysWebService_Contracts.ActiveGiveawayResponse>(`giveaways/${groupID}`);
	}

	getActiveForRegion(regionKey:string, groupID:string):Promise<Curse_Friends_GiveawaysWebService_Contracts.ActiveGiveawayResponse> {
		return this._getForRegion<Curse_Friends_GiveawaysWebService_Contracts.ActiveGiveawayResponse>(regionKey,`giveaways/${groupID}`);
	}

	getLatestSettings(groupID:string):Promise<Curse_Friends_NotificationContracts.GroupGiveawaySettingsNotification> {
		return this._get<Curse_Friends_NotificationContracts.GroupGiveawaySettingsNotification>(`giveaways/${groupID}/settings`);
	}

	getLatestSettingsForRegion(regionKey:string, groupID:string):Promise<Curse_Friends_NotificationContracts.GroupGiveawaySettingsNotification> {
		return this._getForRegion<Curse_Friends_NotificationContracts.GroupGiveawaySettingsNotification>(regionKey,`giveaways/${groupID}/settings`);
	}

	create(groupID:string, request:Curse_Friends_GiveawaysWebService_Contracts.CreateGiveawayRequest):Promise<Curse_Friends_NotificationContracts.GroupGiveawayNotification> {
		return this._post<Curse_Friends_NotificationContracts.GroupGiveawayNotification>(`giveaways/${groupID}`, request);
	}

	createForRegion(regionKey:string, groupID:string, request:Curse_Friends_GiveawaysWebService_Contracts.CreateGiveawayRequest):Promise<Curse_Friends_NotificationContracts.GroupGiveawayNotification> {
		return this._postForRegion<Curse_Friends_NotificationContracts.GroupGiveawayNotification>(regionKey,`giveaways/${groupID}`, request);
	}

	get(groupID:string, giveawayID:number):Promise<Curse_Friends_NotificationContracts.GroupGiveawayNotification> {
		return this._get<Curse_Friends_NotificationContracts.GroupGiveawayNotification>(`giveaways/${groupID}/${giveawayID}`);
	}

	getForRegion(regionKey:string, groupID:string, giveawayID:number):Promise<Curse_Friends_NotificationContracts.GroupGiveawayNotification> {
		return this._getForRegion<Curse_Friends_NotificationContracts.GroupGiveawayNotification>(regionKey,`giveaways/${groupID}/${giveawayID}`);
	}

	continue(groupID:string, giveawayID:number):Promise<void> {
		return this._post<void>(`giveaways/${groupID}/${giveawayID}/continues`);
	}

	continueForRegion(regionKey:string, groupID:string, giveawayID:number):Promise<void> {
		return this._postForRegion<void>(regionKey,`giveaways/${groupID}/${giveawayID}/continues`);
	}

	end(groupID:string, giveawayID:number, keepActive:boolean):Promise<void> {
		return this._delete<void>(`giveaways/${groupID}/${giveawayID}?keepActive=${keepActive}`);
	}

	endForRegion(regionKey:string, groupID:string, giveawayID:number, keepActive:boolean):Promise<void> {
		return this._deleteForRegion<void>(regionKey,`giveaways/${groupID}/${giveawayID}?keepActive=${keepActive}`);
	}

	roll(groupID:string, giveawayID:number):Promise<void> {
		return this._post<void>(`giveaways/${groupID}/${giveawayID}/rolls`);
	}

	rollForRegion(regionKey:string, groupID:string, giveawayID:number):Promise<void> {
		return this._postForRegion<void>(regionKey,`giveaways/${groupID}/${giveawayID}/rolls`);
	}

	register(groupID:string, giveawayID:number, referrerUserID:number):Promise<boolean> {
		return this._post<boolean>(`giveaways/${groupID}/${giveawayID}/participation`, referrerUserID);
	}

	registerForRegion(regionKey:string, groupID:string, giveawayID:number, referrerUserID:number):Promise<boolean> {
		return this._postForRegion<boolean>(regionKey,`giveaways/${groupID}/${giveawayID}/participation`, referrerUserID);
	}

	unregister(groupID:string, giveawayID:number):Promise<void> {
		return this._delete<void>(`giveaways/${groupID}/${giveawayID}/participation`);
	}

	unregisterForRegion(regionKey:string, groupID:string, giveawayID:number):Promise<void> {
		return this._deleteForRegion<void>(regionKey,`giveaways/${groupID}/${giveawayID}/participation`);
	}

	claim(groupID:string, giveawayID:number):Promise<void> {
		return this._post<void>(`giveaways/${groupID}/${giveawayID}/claims`);
	}

	claimForRegion(regionKey:string, groupID:string, giveawayID:number):Promise<void> {
		return this._postForRegion<void>(regionKey,`giveaways/${groupID}/${giveawayID}/claims`);
	}

	getHistory(groupID:string, pageSize:number, pageNumber:number):Promise<Curse_Friends_GiveawaysWebService_Contracts.GroupGiveawayRollResult[]> {
		return this._get<Curse_Friends_GiveawaysWebService_Contracts.GroupGiveawayRollResult[]>(`giveaways/${groupID}/history?pageSize=${pageSize}&pageNumber=${pageNumber}`);
	}

	getHistoryForRegion(regionKey:string, groupID:string, pageSize:number, pageNumber:number):Promise<Curse_Friends_GiveawaysWebService_Contracts.GroupGiveawayRollResult[]> {
		return this._getForRegion<Curse_Friends_GiveawaysWebService_Contracts.GroupGiveawayRollResult[]>(regionKey,`giveaways/${groupID}/history?pageSize=${pageSize}&pageNumber=${pageNumber}`);
	}

	searchHistory(groupID:string, request:Curse_Friends_GiveawaysWebService_Contracts.GetGiveawayHistoryRequest):Promise<Curse_Friends_GiveawaysWebService_Contracts.GroupGiveawayRollResult[]> {
		return this._post<Curse_Friends_GiveawaysWebService_Contracts.GroupGiveawayRollResult[]>(`giveaways/${groupID}/history/search`, request);
	}

	searchHistoryForRegion(regionKey:string, groupID:string, request:Curse_Friends_GiveawaysWebService_Contracts.GetGiveawayHistoryRequest):Promise<Curse_Friends_GiveawaysWebService_Contracts.GroupGiveawayRollResult[]> {
		return this._postForRegion<Curse_Friends_GiveawaysWebService_Contracts.GroupGiveawayRollResult[]>(regionKey,`giveaways/${groupID}/history/search`, request);
	}



}