import * as Curse_Friends_GroupsWebService_Contracts from './models/Curse.Friends.GroupsWebService.Contracts';
import * as Curse_Friends_NotificationContracts from './models/Curse.Friends.NotificationContracts';
import * as Curse_Friends_Enums from './models/Curse.Friends.Enums';

import { BaseWebServiceClient as base } from './lib/BaseWebServiceClient';
export class GroupsApiService extends base {    

	setServerFeatured(serverID:string, isFeatured:boolean):Promise<void> {
		return this._post<void>(`groups/api/${serverID}/featured`, isFeatured);
	}

	setServerFeaturedForRegion(regionKey:string, serverID:string, isFeatured:boolean):Promise<void> {
		return this._postForRegion<void>(regionKey,`groups/api/${serverID}/featured`, isFeatured);
	}

	addOwner(groupID:string, userID:number):Promise<void> {
		return this._post<void>(`groups/api/${groupID}/members/owners`, userID);
	}

	addOwnerForRegion(regionKey:string, groupID:string, userID:number):Promise<void> {
		return this._postForRegion<void>(regionKey,`groups/api/${groupID}/members/owners`, userID);
	}

	blacklistVanityUrls(urlsToBlacklist:string[]):Promise<void> {
		return this._post<void>(`groups/api/vanity-urls/blacklists`, urlsToBlacklist);
	}

	blacklistVanityUrlsForRegion(regionKey:string, urlsToBlacklist:string[]):Promise<void> {
		return this._postForRegion<void>(regionKey,`groups/api/vanity-urls/blacklists`, urlsToBlacklist);
	}

	reserveVanityUrls(urlsToReserve:string[]):Promise<void> {
		return this._post<void>(`groups/api/vanity-urls/reserves`, urlsToReserve);
	}

	reserveVanityUrlsForRegion(regionKey:string, urlsToReserve:string[]):Promise<void> {
		return this._postForRegion<void>(regionKey,`groups/api/vanity-urls/reserves`, urlsToReserve);
	}

	assignVanityUrl(groupID:string, url:string):Promise<void> {
		return this._post<void>(`groups/api/vanity-urls/groups/${groupID}`, url);
	}

	assignVanityUrlForRegion(regionKey:string, groupID:string, url:string):Promise<void> {
		return this._postForRegion<void>(regionKey,`groups/api/vanity-urls/groups/${groupID}`, url);
	}

	searchGroups(request:Curse_Friends_GroupsWebService_Contracts.SearchServersRequest):Promise<Curse_Friends_GroupsWebService_Contracts.ApiGroupSearchContract[]> {
		return this._post<Curse_Friends_GroupsWebService_Contracts.ApiGroupSearchContract[]>(`groups/api/discover/search`, request);
	}

	searchGroupsForRegion(regionKey:string, request:Curse_Friends_GroupsWebService_Contracts.SearchServersRequest):Promise<Curse_Friends_GroupsWebService_Contracts.ApiGroupSearchContract[]> {
		return this._postForRegion<Curse_Friends_GroupsWebService_Contracts.ApiGroupSearchContract[]>(regionKey,`groups/api/discover/search`, request);
	}

	markInappropriate(request:Curse_Friends_GroupsWebService_Contracts.MarkInappropriateRequest):Promise<void> {
		return this._post<void>(`groups/api/discover/quarantine`, request);
	}

	markInappropriateForRegion(regionKey:string, request:Curse_Friends_GroupsWebService_Contracts.MarkInappropriateRequest):Promise<void> {
		return this._postForRegion<void>(regionKey,`groups/api/discover/quarantine`, request);
	}

	unmarkInappropriate(serverID:string):Promise<void> {
		return this._post<void>(`groups/api/discover/quarantine/${serverID}`);
	}

	unmarkInappropriateForRegion(regionKey:string, serverID:string):Promise<void> {
		return this._postForRegion<void>(regionKey,`groups/api/discover/quarantine/${serverID}`);
	}



}