import * as Curse_Friends_GroupsWebService_Contracts from './models/Curse.Friends.GroupsWebService.Contracts';
import * as Curse_Friends_NotificationContracts from './models/Curse.Friends.NotificationContracts';
import * as Curse_Friends_Enums from './models/Curse.Friends.Enums';

import { BaseWebServiceClient as base } from './lib/BaseWebServiceClient';
export class GroupsService extends base {    

	create(request:Curse_Friends_GroupsWebService_Contracts.CreateGroupRequest):Promise<Curse_Friends_NotificationContracts.GroupNotification> {
		return this._post<Curse_Friends_NotificationContracts.GroupNotification>(`groups`, request);
	}

	createForRegion(regionKey:string, request:Curse_Friends_GroupsWebService_Contracts.CreateGroupRequest):Promise<Curse_Friends_NotificationContracts.GroupNotification> {
		return this._postForRegion<Curse_Friends_NotificationContracts.GroupNotification>(regionKey,`groups`, request);
	}

	settings(groupID:string, request:Curse_Friends_GroupsWebService_Contracts.ModifyGroupSettingsRequest):Promise<void> {
		return this._post<void>(`groups/${groupID}/settings`, request);
	}

	settingsForRegion(regionKey:string, groupID:string, request:Curse_Friends_GroupsWebService_Contracts.ModifyGroupSettingsRequest):Promise<void> {
		return this._postForRegion<void>(regionKey,`groups/${groupID}/settings`, request);
	}

	getMembers(groupID:string, actives:boolean, page:number, pageSize:number):Promise<Curse_Friends_NotificationContracts.GroupMemberContract[]> {
		return this._get<Curse_Friends_NotificationContracts.GroupMemberContract[]>(`groups/${groupID}/members?actives=${actives}&page=${page}&pageSize=${pageSize}`);
	}

	getMembersForRegion(regionKey:string, groupID:string, actives:boolean, page:number, pageSize:number):Promise<Curse_Friends_NotificationContracts.GroupMemberContract[]> {
		return this._getForRegion<Curse_Friends_NotificationContracts.GroupMemberContract[]>(regionKey,`groups/${groupID}/members?actives=${actives}&page=${page}&pageSize=${pageSize}`);
	}

	addMembers(groupID:string, userIDs:number[]):Promise<void> {
		return this._post<void>(`groups/${groupID}/members`, userIDs);
	}

	addMembersForRegion(regionKey:string, groupID:string, userIDs:number[]):Promise<void> {
		return this._postForRegion<void>(regionKey,`groups/${groupID}/members`, userIDs);
	}

	quickSearchMembers(groupID:string, query:string):Promise<Curse_Friends_NotificationContracts.GroupMemberContract[]> {
		return this._get<Curse_Friends_NotificationContracts.GroupMemberContract[]>(`groups/${groupID}/members/simple-search?query=${encodeURIComponent(query)}`);
	}

	quickSearchMembersForRegion(regionKey:string, groupID:string, query:string):Promise<Curse_Friends_NotificationContracts.GroupMemberContract[]> {
		return this._getForRegion<Curse_Friends_NotificationContracts.GroupMemberContract[]>(regionKey,`groups/${groupID}/members/simple-search?query=${encodeURIComponent(query)}`);
	}

	searchMembers(groupID:string, request:Curse_Friends_GroupsWebService_Contracts.GroupMemberSearchRequest):Promise<Curse_Friends_NotificationContracts.GroupMemberContract[]> {
		return this._post<Curse_Friends_NotificationContracts.GroupMemberContract[]>(`groups/${groupID}/members/search`, request);
	}

	searchMembersForRegion(regionKey:string, groupID:string, request:Curse_Friends_GroupsWebService_Contracts.GroupMemberSearchRequest):Promise<Curse_Friends_NotificationContracts.GroupMemberContract[]> {
		return this._postForRegion<Curse_Friends_NotificationContracts.GroupMemberContract[]>(regionKey,`groups/${groupID}/members/search`, request);
	}

	getMember(groupID:string, userID:number):Promise<Curse_Friends_NotificationContracts.GroupMemberContract> {
		return this._get<Curse_Friends_NotificationContracts.GroupMemberContract>(`groups/${groupID}/members/${userID}`);
	}

	getMemberForRegion(regionKey:string, groupID:string, userID:number):Promise<Curse_Friends_NotificationContracts.GroupMemberContract> {
		return this._getForRegion<Curse_Friends_NotificationContracts.GroupMemberContract>(regionKey,`groups/${groupID}/members/${userID}`);
	}

	removeMember(groupID:string, userID:number):Promise<void> {
		return this._delete<void>(`groups/${groupID}/members/${userID}`);
	}

	removeMemberForRegion(regionKey:string, groupID:string, userID:number):Promise<void> {
		return this._deleteForRegion<void>(regionKey,`groups/${groupID}/members/${userID}`);
	}

	transferOwnership(groupID:string, userID:number):Promise<void> {
		return this._post<void>(`groups/${groupID}/members/transfer-ownership`, userID);
	}

	transferOwnershipForRegion(regionKey:string, groupID:string, userID:number):Promise<void> {
		return this._postForRegion<void>(regionKey,`groups/${groupID}/members/transfer-ownership`, userID);
	}

	details(groupID:string, showDeletedChannels:boolean):Promise<Curse_Friends_NotificationContracts.GroupNotification> {
		return this._get<Curse_Friends_NotificationContracts.GroupNotification>(`groups/${groupID}?showDeletedChannels=${showDeletedChannels}`);
	}

	detailsForRegion(regionKey:string, groupID:string, showDeletedChannels:boolean):Promise<Curse_Friends_NotificationContracts.GroupNotification> {
		return this._getForRegion<Curse_Friends_NotificationContracts.GroupNotification>(regionKey,`groups/${groupID}?showDeletedChannels=${showDeletedChannels}`);
	}

	toggleFavorites(requests:Curse_Friends_GroupsWebService_Contracts.ToggleFavoriteRequest[]):Promise<void> {
		return this._post<void>(`groups/favorites`, requests);
	}

	toggleFavoritesForRegion(regionKey:string, requests:Curse_Friends_GroupsWebService_Contracts.ToggleFavoriteRequest[]):Promise<void> {
		return this._postForRegion<void>(regionKey,`groups/favorites`, requests);
	}

	favorite(groupID:string):Promise<void> {
		return this._post<void>(`groups/${groupID}/favorite`);
	}

	favoriteForRegion(regionKey:string, groupID:string):Promise<void> {
		return this._postForRegion<void>(regionKey,`groups/${groupID}/favorite`);
	}

	unfavorite(groupID:string):Promise<void> {
		return this._post<void>(`groups/${groupID}/unfavorite`);
	}

	unfavoriteForRegion(regionKey:string, groupID:string):Promise<void> {
		return this._postForRegion<void>(regionKey,`groups/${groupID}/unfavorite`);
	}

	leave(groupID:string):Promise<void> {
		return this._post<void>(`groups/${groupID}/leave`);
	}

	leaveForRegion(regionKey:string, groupID:string):Promise<void> {
		return this._postForRegion<void>(regionKey,`groups/${groupID}/leave`);
	}

	nickname(groupID:string, request:Curse_Friends_GroupsWebService_Contracts.GroupMemberNicknameRequest):Promise<void> {
		return this._post<void>(`groups/${groupID}/nickname`, request);
	}

	nicknameForRegion(regionKey:string, groupID:string, request:Curse_Friends_GroupsWebService_Contracts.GroupMemberNicknameRequest):Promise<void> {
		return this._postForRegion<void>(regionKey,`groups/${groupID}/nickname`, request);
	}

	changeNotificationPreferencesBulk(preferences:Curse_Friends_GroupsWebService_Contracts.BulkGroupNotificationPreferences[]):Promise<void> {
		return this._post<void>(`groups/notification-preferences`, preferences);
	}

	changeNotificationPreferencesBulkForRegion(regionKey:string, preferences:Curse_Friends_GroupsWebService_Contracts.BulkGroupNotificationPreferences[]):Promise<void> {
		return this._postForRegion<void>(regionKey,`groups/notification-preferences`, preferences);
	}

	changeNotificationPreferences(groupID:string, preferences:Curse_Friends_GroupsWebService_Contracts.GroupNotificationPreferences):Promise<void> {
		return this._post<void>(`groups/${groupID}/notification-preferences`, preferences);
	}

	changeNotificationPreferencesForRegion(regionKey:string, groupID:string, preferences:Curse_Friends_GroupsWebService_Contracts.GroupNotificationPreferences):Promise<void> {
		return this._postForRegion<void>(regionKey,`groups/${groupID}/notification-preferences`, preferences);
	}

	getGroupEvents(groupID:string, pageSize:number, pageNumber:number):Promise<Curse_Friends_NotificationContracts.GroupEventContract[]> {
		return this._get<Curse_Friends_NotificationContracts.GroupEventContract[]>(`groups/${groupID}/events?pageSize=${pageSize}&pageNumber=${pageNumber}`);
	}

	getGroupEventsForRegion(regionKey:string, groupID:string, pageSize:number, pageNumber:number):Promise<Curse_Friends_NotificationContracts.GroupEventContract[]> {
		return this._getForRegion<Curse_Friends_NotificationContracts.GroupEventContract[]>(regionKey,`groups/${groupID}/events?pageSize=${pageSize}&pageNumber=${pageNumber}`);
	}

	searchGroupEvents(groupID:string, request:Curse_Friends_GroupsWebService_Contracts.SearchGroupEventsRequest):Promise<Curse_Friends_NotificationContracts.GroupEventContract[]> {
		return this._post<Curse_Friends_NotificationContracts.GroupEventContract[]>(`groups/${groupID}/events/search`, request);
	}

	searchGroupEventsForRegion(regionKey:string, groupID:string, request:Curse_Friends_GroupsWebService_Contracts.SearchGroupEventsRequest):Promise<Curse_Friends_NotificationContracts.GroupEventContract[]> {
		return this._postForRegion<Curse_Friends_NotificationContracts.GroupEventContract[]>(regionKey,`groups/${groupID}/events/search`, request);
	}



}