import * as Curse_Friends_ImagesWebService_Contracts from './models/Curse.Friends.ImagesWebService.Contracts';
import * as Curse_Friends_MicroService_Contracts from './models/Curse.Friends.MicroService.Contracts';

import { BaseWebServiceClient as base } from './lib/BaseWebServiceClient';
export class ImagesAdminService extends base {    

	findImage(region:Curse_Friends_ImagesWebService_Contracts.FileRegion, imageKey:string):Promise<Curse_Friends_ImagesWebService_Contracts.ImageMetadataResponse> {
		return this._get<Curse_Friends_ImagesWebService_Contracts.ImageMetadataResponse>(`images/api/${region}/${imageKey}`);
	}

	findImageForRegion(regionKey:string, region:Curse_Friends_ImagesWebService_Contracts.FileRegion, imageKey:string):Promise<Curse_Friends_ImagesWebService_Contracts.ImageMetadataResponse> {
		return this._getForRegion<Curse_Friends_ImagesWebService_Contracts.ImageMetadataResponse>(regionKey,`images/api/${region}/${imageKey}`);
	}

	purgeImage(region:Curse_Friends_ImagesWebService_Contracts.FileRegion, imageKey:string):Promise<void> {
		return this._delete<void>(`images/api/${region}/${imageKey}`);
	}

	purgeImageForRegion(regionKey:string, region:Curse_Friends_ImagesWebService_Contracts.FileRegion, imageKey:string):Promise<void> {
		return this._deleteForRegion<void>(regionKey,`images/api/${region}/${imageKey}`);
	}



}