import * as Curse_Friends_GroupsWebService_Contracts from './models/Curse.Friends.GroupsWebService.Contracts';
import * as Curse_Friends_NotificationContracts from './models/Curse.Friends.NotificationContracts';
import * as Curse_Friends_Enums from './models/Curse.Friends.Enums';

import { BaseWebServiceClient as base } from './lib/BaseWebServiceClient';
export class InvitationsService extends base {    

	get(inviteCode:string):Promise<Curse_Friends_NotificationContracts.GroupInvitationNotification> {
		return this._get<Curse_Friends_NotificationContracts.GroupInvitationNotification>(`invitations/${inviteCode}`);
	}

	getForRegion(regionKey:string, inviteCode:string):Promise<Curse_Friends_NotificationContracts.GroupInvitationNotification> {
		return this._getForRegion<Curse_Friends_NotificationContracts.GroupInvitationNotification>(regionKey,`invitations/${inviteCode}`);
	}

	getDisplayDetails(inviteCode:string):Promise<Curse_Friends_GroupsWebService_Contracts.GetInvitationDisplayDetailsResponse> {
		return this._get<Curse_Friends_GroupsWebService_Contracts.GetInvitationDisplayDetailsResponse>(`invitations/${inviteCode}/display`);
	}

	getDisplayDetailsForRegion(regionKey:string, inviteCode:string):Promise<Curse_Friends_GroupsWebService_Contracts.GetInvitationDisplayDetailsResponse> {
		return this._getForRegion<Curse_Friends_GroupsWebService_Contracts.GetInvitationDisplayDetailsResponse>(regionKey,`invitations/${inviteCode}/display`);
	}

	redeem(inviteCode:string):Promise<Curse_Friends_GroupsWebService_Contracts.GroupInvitationRedeemResponse> {
		return this._post<Curse_Friends_GroupsWebService_Contracts.GroupInvitationRedeemResponse>(`invitations/${inviteCode}`);
	}

	redeemForRegion(regionKey:string, inviteCode:string):Promise<Curse_Friends_GroupsWebService_Contracts.GroupInvitationRedeemResponse> {
		return this._postForRegion<Curse_Friends_GroupsWebService_Contracts.GroupInvitationRedeemResponse>(regionKey,`invitations/${inviteCode}`);
	}



}