import * as Curse_Friends_NotificationContracts from './models/Curse.Friends.NotificationContracts';
import * as Curse_Friends_Enums from './models/Curse.Friends.Enums';
import * as Curse_Friends_SyncWebService_Contracts from './models/Curse.Friends.SyncWebService.Contracts';

import { BaseWebServiceClient as base } from './lib/BaseWebServiceClient';
export class LinkedAccountsService extends base {    

	getMyAccounts():Promise<Curse_Friends_NotificationContracts.ExternalAccountContract[]> {
		return this._get<Curse_Friends_NotificationContracts.ExternalAccountContract[]>(`linked-accounts`);
	}

	getMyAccountsForRegion(regionKey:string):Promise<Curse_Friends_NotificationContracts.ExternalAccountContract[]> {
		return this._getForRegion<Curse_Friends_NotificationContracts.ExternalAccountContract[]>(regionKey,`linked-accounts`);
	}

	createTemporaryAccessToken():Promise<Curse_Friends_NotificationContracts.TemporaryAccessTokenContract> {
		return this._post<Curse_Friends_NotificationContracts.TemporaryAccessTokenContract>(`linked-accounts/token`);
	}

	createTemporaryAccessTokenForRegion(regionKey:string):Promise<Curse_Friends_NotificationContracts.TemporaryAccessTokenContract> {
		return this._postForRegion<Curse_Friends_NotificationContracts.TemporaryAccessTokenContract>(regionKey,`linked-accounts/token`);
	}

	linkAccountWithToken(type:Curse_Friends_Enums.AccountType, userID:number, accessToken:string, forceVerify:boolean, successRedirectUrl:string, failureRedirectUrl:string, gameRegion:number):Promise<string> {
		return this._get<string>(`linked-accounts/${type}?userID=${userID}&accessToken=${accessToken}&forceVerify=${forceVerify}&successRedirectUrl=${encodeURIComponent(successRedirectUrl)}&failureRedirectUrl=${encodeURIComponent(failureRedirectUrl)}&gameRegion=${gameRegion}`);
	}

	linkAccountWithTokenForRegion(regionKey:string, type:Curse_Friends_Enums.AccountType, userID:number, accessToken:string, forceVerify:boolean, successRedirectUrl:string, failureRedirectUrl:string, gameRegion:number):Promise<string> {
		return this._getForRegion<string>(regionKey,`linked-accounts/${type}?userID=${userID}&accessToken=${accessToken}&forceVerify=${forceVerify}&successRedirectUrl=${encodeURIComponent(successRedirectUrl)}&failureRedirectUrl=${encodeURIComponent(failureRedirectUrl)}&gameRegion=${gameRegion}`);
	}

	linkAccount(type:Curse_Friends_Enums.AccountType, request:Curse_Friends_SyncWebService_Contracts.LinkExternalAccountRequest):Promise<void> {
		return this._post<void>(`linked-accounts/${type}`, request);
	}

	linkAccountForRegion(regionKey:string, type:Curse_Friends_Enums.AccountType, request:Curse_Friends_SyncWebService_Contracts.LinkExternalAccountRequest):Promise<void> {
		return this._postForRegion<void>(regionKey,`linked-accounts/${type}`, request);
	}

	unlinkAccount(type:Curse_Friends_Enums.AccountType, accountID:string):Promise<void> {
		return this._delete<void>(`linked-accounts/links/${type}/${accountID}`);
	}

	unlinkAccountForRegion(regionKey:string, type:Curse_Friends_Enums.AccountType, accountID:string):Promise<void> {
		return this._deleteForRegion<void>(regionKey,`linked-accounts/links/${type}/${accountID}`);
	}

	resync():Promise<Curse_Friends_SyncWebService_Contracts.AccountResyncResponse> {
		return this._post<Curse_Friends_SyncWebService_Contracts.AccountResyncResponse>(`linked-accounts/resync`);
	}

	resyncForRegion(regionKey:string):Promise<Curse_Friends_SyncWebService_Contracts.AccountResyncResponse> {
		return this._postForRegion<Curse_Friends_SyncWebService_Contracts.AccountResyncResponse>(regionKey,`linked-accounts/resync`);
	}



}