import * as Curse_Friends_NotificationContracts from './models/Curse.Friends.NotificationContracts';
import * as Curse_Friends_Enums from './models/Curse.Friends.Enums';
import * as Curse_Friends_SyncWebService_Contracts from './models/Curse.Friends.SyncWebService.Contracts';

import { BaseWebServiceClient as base } from './lib/BaseWebServiceClient';
export class LinkedCommunitiesService extends base {    

	resync(communityID:string):Promise<void> {
		return this._post<void>(`linked-communities/${communityID}/resync`);
	}

	resyncForRegion(regionKey:string, communityID:string):Promise<void> {
		return this._postForRegion<void>(regionKey,`linked-communities/${communityID}/resync`);
	}

	getSyncedEmotes(type:Curse_Friends_Enums.AccountType, communityID:string):Promise<Curse_Friends_NotificationContracts.ExternalCommunityEmoticonContract[]> {
		return this._get<Curse_Friends_NotificationContracts.ExternalCommunityEmoticonContract[]>(`linked-communities/${type}/${communityID}/emotes`);
	}

	getSyncedEmotesForRegion(regionKey:string, type:Curse_Friends_Enums.AccountType, communityID:string):Promise<Curse_Friends_NotificationContracts.ExternalCommunityEmoticonContract[]> {
		return this._getForRegion<Curse_Friends_NotificationContracts.ExternalCommunityEmoticonContract[]>(regionKey,`linked-communities/${type}/${communityID}/emotes`);
	}

	link(type:Curse_Friends_Enums.AccountType, groupID:string, communityID:string):Promise<void> {
		return this._post<void>(`linked-communities/${type}/${communityID}/links/${groupID}`);
	}

	linkForRegion(regionKey:string, type:Curse_Friends_Enums.AccountType, groupID:string, communityID:string):Promise<void> {
		return this._postForRegion<void>(regionKey,`linked-communities/${type}/${communityID}/links/${groupID}`);
	}

	unlink(type:Curse_Friends_Enums.AccountType, groupID:string, communityID:string):Promise<void> {
		return this._delete<void>(`linked-communities/${type}/${communityID}/links/${groupID}`);
	}

	unlinkForRegion(regionKey:string, type:Curse_Friends_Enums.AccountType, groupID:string, communityID:string):Promise<void> {
		return this._deleteForRegion<void>(regionKey,`linked-communities/${type}/${communityID}/links/${groupID}`);
	}

	getLinkedCommunities(groupID:string):Promise<Curse_Friends_NotificationContracts.ExternalCommunityLinkContract[]> {
		return this._get<Curse_Friends_NotificationContracts.ExternalCommunityLinkContract[]>(`linked-communities/${groupID}`);
	}

	getLinkedCommunitiesForRegion(regionKey:string, groupID:string):Promise<Curse_Friends_NotificationContracts.ExternalCommunityLinkContract[]> {
		return this._getForRegion<Curse_Friends_NotificationContracts.ExternalCommunityLinkContract[]>(regionKey,`linked-communities/${groupID}`);
	}

	changeCommunitySettings(groupID:string, type:Curse_Friends_Enums.AccountType, communityID:string, request:Curse_Friends_SyncWebService_Contracts.ChangeCommunitySettingsRequest):Promise<Curse_Friends_NotificationContracts.ExternalCommunityLinkContract> {
		return this._post<Curse_Friends_NotificationContracts.ExternalCommunityLinkContract>(`linked-communities/${groupID}/${type}/${communityID}/settings`, request);
	}

	changeCommunitySettingsForRegion(regionKey:string, groupID:string, type:Curse_Friends_Enums.AccountType, communityID:string, request:Curse_Friends_SyncWebService_Contracts.ChangeCommunitySettingsRequest):Promise<Curse_Friends_NotificationContracts.ExternalCommunityLinkContract> {
		return this._postForRegion<Curse_Friends_NotificationContracts.ExternalCommunityLinkContract>(regionKey,`linked-communities/${groupID}/${type}/${communityID}/settings`, request);
	}

	getCommunityMemberships():Promise<Curse_Friends_SyncWebService_Contracts.SyncedCommunityMembershipResponse> {
		return this._get<Curse_Friends_SyncWebService_Contracts.SyncedCommunityMembershipResponse>(`linked-communities/memberships`);
	}

	getCommunityMembershipsForRegion(regionKey:string):Promise<Curse_Friends_SyncWebService_Contracts.SyncedCommunityMembershipResponse> {
		return this._getForRegion<Curse_Friends_SyncWebService_Contracts.SyncedCommunityMembershipResponse>(regionKey,`linked-communities/memberships`);
	}

	getPremiumMembers(type:Curse_Friends_Enums.AccountType, communityID:string, query:string, groupID:string, pageSize:number, pageNumber:number):Promise<Curse_Friends_SyncWebService_Contracts.PremiumMemberSearchResponse> {
		return this._get<Curse_Friends_SyncWebService_Contracts.PremiumMemberSearchResponse>(`linked-communities/${type}/${communityID}/subscribers?query=${encodeURIComponent(query)}&groupID=${groupID}&pageSize=${pageSize}&pageNumber=${pageNumber}`);
	}

	getPremiumMembersForRegion(regionKey:string, type:Curse_Friends_Enums.AccountType, communityID:string, query:string, groupID:string, pageSize:number, pageNumber:number):Promise<Curse_Friends_SyncWebService_Contracts.PremiumMemberSearchResponse> {
		return this._getForRegion<Curse_Friends_SyncWebService_Contracts.PremiumMemberSearchResponse>(regionKey,`linked-communities/${type}/${communityID}/subscribers?query=${encodeURIComponent(query)}&groupID=${groupID}&pageSize=${pageSize}&pageNumber=${pageNumber}`);
	}

	followChannel(communityID:string):Promise<Curse_Friends_SyncWebService_Contracts.FollowTwitchChannelResponse> {
		return this._post<Curse_Friends_SyncWebService_Contracts.FollowTwitchChannelResponse>(`linked-communities/twitch/${communityID}/follow`);
	}

	followChannelForRegion(regionKey:string, communityID:string):Promise<Curse_Friends_SyncWebService_Contracts.FollowTwitchChannelResponse> {
		return this._postForRegion<Curse_Friends_SyncWebService_Contracts.FollowTwitchChannelResponse>(regionKey,`linked-communities/twitch/${communityID}/follow`);
	}



}