import * as Curse_Friends_NotificationContracts from './models/Curse.Friends.NotificationContracts';
import * as Curse_Friends_Enums from './models/Curse.Friends.Enums';
import * as Curse_Friends_SyncWebService_Contracts from './models/Curse.Friends.SyncWebService.Contracts';

import { BaseWebServiceClient as base } from './lib/BaseWebServiceClient';
export class LinkedGuildsService extends base {    

	linkGuild(type:Curse_Friends_Enums.AccountType, region:number, server:string, guildName:string, groupID:string, request:Curse_Friends_SyncWebService_Contracts.LinkGuildRequest):Promise<void> {
		return this._post<void>(`linked-guilds/${type}/${region}/${server}/${guildName}/links/${groupID}`, request);
	}

	linkGuildForRegion(regionKey:string, type:Curse_Friends_Enums.AccountType, region:number, server:string, guildName:string, groupID:string, request:Curse_Friends_SyncWebService_Contracts.LinkGuildRequest):Promise<void> {
		return this._postForRegion<void>(regionKey,`linked-guilds/${type}/${region}/${server}/${guildName}/links/${groupID}`, request);
	}

	unlinkGuild(type:Curse_Friends_Enums.AccountType, region:number, server:string, guildName:string, groupID:string):Promise<void> {
		return this._delete<void>(`linked-guilds/${type}/${region}/${server}/${guildName}/links/${groupID}`);
	}

	unlinkGuildForRegion(regionKey:string, type:Curse_Friends_Enums.AccountType, region:number, server:string, guildName:string, groupID:string):Promise<void> {
		return this._deleteForRegion<void>(regionKey,`linked-guilds/${type}/${region}/${server}/${guildName}/links/${groupID}`);
	}

	getMyGuilds(type:Curse_Friends_Enums.AccountType):Promise<Curse_Friends_SyncWebService_Contracts.GuildDetailsContract[]> {
		return this._get<Curse_Friends_SyncWebService_Contracts.GuildDetailsContract[]>(`linked-guilds/${type}`);
	}

	getMyGuildsForRegion(regionKey:string, type:Curse_Friends_Enums.AccountType):Promise<Curse_Friends_SyncWebService_Contracts.GuildDetailsContract[]> {
		return this._getForRegion<Curse_Friends_SyncWebService_Contracts.GuildDetailsContract[]>(regionKey,`linked-guilds/${type}`);
	}



}