import * as Curse_Friends_LoginsWebService_Contracts from './models/Curse.Friends.LoginsWebService.Contracts';
import * as Curse_Friends_Enums from './models/Curse.Friends.Enums';

import { BaseWebServiceClient as base } from './lib/BaseWebServiceClient';
export class LoginApiService extends base {    

	autoProvisionTwitchAccount(twitchID:string):Promise<Curse_Friends_LoginsWebService_Contracts.IdentityMergeStateContract> {
		return this._post<Curse_Friends_LoginsWebService_Contracts.IdentityMergeStateContract>(`logins/api/provisioned/twitch/${twitchID}`);
	}

	autoProvisionTwitchAccountForRegion(regionKey:string, twitchID:string):Promise<Curse_Friends_LoginsWebService_Contracts.IdentityMergeStateContract> {
		return this._postForRegion<Curse_Friends_LoginsWebService_Contracts.IdentityMergeStateContract>(regionKey,`logins/api/provisioned/twitch/${twitchID}`);
	}

	twitchUnmerge(twitchID:number):Promise<void> {
		return this._post<void>(`logins/api/twitch-unmerge/${twitchID}`);
	}

	twitchUnmergeForRegion(regionKey:string, twitchID:number):Promise<void> {
		return this._postForRegion<void>(regionKey,`logins/api/twitch-unmerge/${twitchID}`);
	}



}