import * as Curse_Friends_LoginsWebService_Contracts from './models/Curse.Friends.LoginsWebService.Contracts';
import * as Curse_Friends_Enums from './models/Curse.Friends.Enums';

import { BaseWebServiceClient as base } from './lib/BaseWebServiceClient';
export class LoginService extends base {    

	login(loginRequest:Curse_Friends_LoginsWebService_Contracts.LoginRequest):Promise<Curse_Friends_LoginsWebService_Contracts.LoginResponse> {
		return this._post<Curse_Friends_LoginsWebService_Contracts.LoginResponse>(`login`, loginRequest);
	}

	loginForRegion(regionKey:string, loginRequest:Curse_Friends_LoginsWebService_Contracts.LoginRequest):Promise<Curse_Friends_LoginsWebService_Contracts.LoginResponse> {
		return this._postForRegion<Curse_Friends_LoginsWebService_Contracts.LoginResponse>(regionKey,`login`, loginRequest);
	}

	renewToken():Promise<Curse_Friends_LoginsWebService_Contracts.RenewTokenResponseContract> {
		return this._post<Curse_Friends_LoginsWebService_Contracts.RenewTokenResponseContract>(`login/renew`);
	}

	renewTokenForRegion(regionKey:string):Promise<Curse_Friends_LoginsWebService_Contracts.RenewTokenResponseContract> {
		return this._postForRegion<Curse_Friends_LoginsWebService_Contracts.RenewTokenResponseContract>(regionKey,`login/renew`);
	}

	loginWithNetworkSession(request:Curse_Friends_LoginsWebService_Contracts.LoginWithNetworkSessionRequest):Promise<Curse_Friends_LoginsWebService_Contracts.LoginResponse> {
		return this._post<Curse_Friends_LoginsWebService_Contracts.LoginResponse>(`login/network-session`, request);
	}

	loginWithNetworkSessionForRegion(regionKey:string, request:Curse_Friends_LoginsWebService_Contracts.LoginWithNetworkSessionRequest):Promise<Curse_Friends_LoginsWebService_Contracts.LoginResponse> {
		return this._postForRegion<Curse_Friends_LoginsWebService_Contracts.LoginResponse>(regionKey,`login/network-session`, request);
	}

	twitchOAuth(request:Curse_Friends_LoginsWebService_Contracts.TwitchOAuthRequest):Promise<Curse_Friends_LoginsWebService_Contracts.TwitchOAuthResponse> {
		return this._post<Curse_Friends_LoginsWebService_Contracts.TwitchOAuthResponse>(`login/twitch-oauth`, request);
	}

	twitchOAuthForRegion(regionKey:string, request:Curse_Friends_LoginsWebService_Contracts.TwitchOAuthRequest):Promise<Curse_Friends_LoginsWebService_Contracts.TwitchOAuthResponse> {
		return this._postForRegion<Curse_Friends_LoginsWebService_Contracts.TwitchOAuthResponse>(regionKey,`login/twitch-oauth`, request);
	}

	twitchMergeNew(request:Curse_Friends_LoginsWebService_Contracts.TwitchMergeNewRequest):Promise<Curse_Friends_LoginsWebService_Contracts.TwitchMergeResponse> {
		return this._post<Curse_Friends_LoginsWebService_Contracts.TwitchMergeResponse>(`login/twitch-merge-new`, request);
	}

	twitchMergeNewForRegion(regionKey:string, request:Curse_Friends_LoginsWebService_Contracts.TwitchMergeNewRequest):Promise<Curse_Friends_LoginsWebService_Contracts.TwitchMergeResponse> {
		return this._postForRegion<Curse_Friends_LoginsWebService_Contracts.TwitchMergeResponse>(regionKey,`login/twitch-merge-new`, request);
	}

	twitchMergeExisting(request:Curse_Friends_LoginsWebService_Contracts.TwitchMergeExistingRequest):Promise<Curse_Friends_LoginsWebService_Contracts.TwitchMergeResponse> {
		return this._post<Curse_Friends_LoginsWebService_Contracts.TwitchMergeResponse>(`login/twitch-merge-existing`, request);
	}

	twitchMergeExistingForRegion(regionKey:string, request:Curse_Friends_LoginsWebService_Contracts.TwitchMergeExistingRequest):Promise<Curse_Friends_LoginsWebService_Contracts.TwitchMergeResponse> {
		return this._postForRegion<Curse_Friends_LoginsWebService_Contracts.TwitchMergeResponse>(regionKey,`login/twitch-merge-existing`, request);
	}

	twitchMergeTempAccount(request:Curse_Friends_LoginsWebService_Contracts.TwitchMergeTempAccountRequest):Promise<Curse_Friends_LoginsWebService_Contracts.TwitchMergeResponse> {
		return this._post<Curse_Friends_LoginsWebService_Contracts.TwitchMergeResponse>(`login/twitch-merge-temp-account`, request);
	}

	twitchMergeTempAccountForRegion(regionKey:string, request:Curse_Friends_LoginsWebService_Contracts.TwitchMergeTempAccountRequest):Promise<Curse_Friends_LoginsWebService_Contracts.TwitchMergeResponse> {
		return this._postForRegion<Curse_Friends_LoginsWebService_Contracts.TwitchMergeResponse>(regionKey,`login/twitch-merge-temp-account`, request);
	}

	twitchUnmerge(twitchID:number):Promise<void> {
		return this._post<void>(`login/twitch-unmerge/${twitchID}`);
	}

	twitchUnmergeForRegion(regionKey:string, twitchID:number):Promise<void> {
		return this._postForRegion<void>(regionKey,`login/twitch-unmerge/${twitchID}`);
	}

	testHmac(username:string):Promise<string> {
		return this._get<string>(`login/test-hmac/${username}`);
	}

	testHmacForRegion(regionKey:string, username:string):Promise<string> {
		return this._getForRegion<string>(regionKey,`login/test-hmac/${username}`);
	}

	getFuelToken():Promise<Curse_Friends_LoginsWebService_Contracts.FuelAuthorizationResponseContract> {
		return this._post<Curse_Friends_LoginsWebService_Contracts.FuelAuthorizationResponseContract>(`login/fuel`);
	}

	getFuelTokenForRegion(regionKey:string):Promise<Curse_Friends_LoginsWebService_Contracts.FuelAuthorizationResponseContract> {
		return this._postForRegion<Curse_Friends_LoginsWebService_Contracts.FuelAuthorizationResponseContract>(regionKey,`login/fuel`);
	}



}