import * as Curse_Friends_NotificationContracts from './models/Curse.Friends.NotificationContracts';
import * as Curse_SocketMessages from './models/Curse.SocketMessages';
import * as Curse_Friends_Enums from './models/Curse.Friends.Enums';

import { BaseWebSocketClient  } from './lib/BaseWebSocketClient';


export enum NotificationsServiceContractType {
	ConversationMessageRequest = -2124552136,
	HealthCheckRequest = -1422086075,
	JoinRequest = -2101997347,
	Handshake = -476754606,
	CallNotification = -1669214322,
	CallRespondedNotification = -1145188782,
	ConversationMessageNotification = -635182161,
	ConversationMessageResponse = 705131365,
	ConversationReadNotification = -695526586,
	ExternalAccountChangedNotification = 285733175,
	ExternalCommunityLinkChangedNotification = 738704822,
	FriendshipChangeNotification = 580569888,
	FriendshipRemovedNotification = 1216900677,
	FriendSuggestionNotification = -1001397130,
	GroupBulkMessageDeleteNotification = -929316297,
	GroupChangeNotification = 149631008,
	GroupGiveawayChangedNotification = 1519023790,
	GroupGiveawaySettingsNotification = -1318725298,
	GroupInvitationNotification = -1732183626,
	GroupPollChangedNotification = -1942550100,
	GroupPollSettingsNotification = -34150280,
	GroupPreferenceNotification = 72981382,
	GroupPresenceNotification = 1260535191,
	JoinResponse = -815187584,
	TwitchChatNoticeNotification = -859861814,
	UserBanStatusNotification = 1887505043,
	UserChangeNotification = 937250613,
	UserClientSettingsNotification = -1641871686,

}

export interface NotificationsServiceEvents {
    // Connection State
    connected(id: string): void;
    connecting(): void;
    disconnected(id: string): void;

    // Service Events
	callNotification(data: Curse_Friends_NotificationContracts.CallNotification): void;
	callRespondedNotification(data: Curse_Friends_NotificationContracts.CallRespondedNotification): void;
	conversationMessageNotification(data: Curse_Friends_NotificationContracts.ConversationMessageNotification): void;
	conversationMessageResponse(data: Curse_Friends_NotificationContracts.ConversationMessageResponse): void;
	conversationReadNotification(data: Curse_Friends_NotificationContracts.ConversationReadNotification): void;
	externalAccountChangedNotification(data: Curse_Friends_NotificationContracts.ExternalAccountChangedNotification): void;
	externalCommunityLinkChangedNotification(data: Curse_Friends_NotificationContracts.ExternalCommunityLinkChangedNotification): void;
	friendshipChangeNotification(data: Curse_Friends_NotificationContracts.FriendshipChangeNotification): void;
	friendshipRemovedNotification(data: Curse_Friends_NotificationContracts.FriendshipRemovedNotification): void;
	friendSuggestionNotification(data: Curse_Friends_NotificationContracts.FriendSuggestionNotification): void;
	groupBulkMessageDeleteNotification(data: Curse_Friends_NotificationContracts.GroupBulkMessageDeleteNotification): void;
	groupChangeNotification(data: Curse_Friends_NotificationContracts.GroupChangeNotification): void;
	groupGiveawayChangedNotification(data: Curse_Friends_NotificationContracts.GroupGiveawayChangedNotification): void;
	groupGiveawaySettingsNotification(data: Curse_Friends_NotificationContracts.GroupGiveawaySettingsNotification): void;
	groupInvitationNotification(data: Curse_Friends_NotificationContracts.GroupInvitationNotification): void;
	groupPollChangedNotification(data: Curse_Friends_NotificationContracts.GroupPollChangedNotification): void;
	groupPollSettingsNotification(data: Curse_Friends_NotificationContracts.GroupPollSettingsNotification): void;
	groupPreferenceNotification(data: Curse_Friends_NotificationContracts.GroupPreferenceNotification): void;
	groupPresenceNotification(data: Curse_Friends_NotificationContracts.GroupPresenceNotification): void;
	joinResponse(data: Curse_Friends_NotificationContracts.JoinResponse): void;
	twitchChatNoticeNotification(data: Curse_Friends_NotificationContracts.TwitchChatNoticeNotification): void;
	userBanStatusNotification(data: Curse_Friends_NotificationContracts.UserBanStatusNotification): void;
	userChangeNotification(data: Curse_Friends_NotificationContracts.UserChangeNotification): void;
	userClientSettingsNotification(data: Curse_Friends_NotificationContracts.UserClientSettingsNotification): void;
	handshake(data: Curse_SocketMessages.Handshake): void;
    
}

export abstract class NotificationsService extends BaseWebSocketClient {

    protected events: NotificationsServiceEvents;

    constructor(url: string, events: NotificationsServiceEvents) {        
        this.events = events;
        this.events.connecting();

        super(url, {
			[NotificationsServiceContractType.CallNotification]: (contract: any) => this.onCallNotification(contract),
			[NotificationsServiceContractType.CallRespondedNotification]: (contract: any) => this.onCallRespondedNotification(contract),
			[NotificationsServiceContractType.ConversationMessageNotification]: (contract: any) => this.onConversationMessageNotification(contract),
			[NotificationsServiceContractType.ConversationMessageResponse]: (contract: any) => this.onConversationMessageResponse(contract),
			[NotificationsServiceContractType.ConversationReadNotification]: (contract: any) => this.onConversationReadNotification(contract),
			[NotificationsServiceContractType.ExternalAccountChangedNotification]: (contract: any) => this.onExternalAccountChangedNotification(contract),
			[NotificationsServiceContractType.ExternalCommunityLinkChangedNotification]: (contract: any) => this.onExternalCommunityLinkChangedNotification(contract),
			[NotificationsServiceContractType.FriendshipChangeNotification]: (contract: any) => this.onFriendshipChangeNotification(contract),
			[NotificationsServiceContractType.FriendshipRemovedNotification]: (contract: any) => this.onFriendshipRemovedNotification(contract),
			[NotificationsServiceContractType.FriendSuggestionNotification]: (contract: any) => this.onFriendSuggestionNotification(contract),
			[NotificationsServiceContractType.GroupBulkMessageDeleteNotification]: (contract: any) => this.onGroupBulkMessageDeleteNotification(contract),
			[NotificationsServiceContractType.GroupChangeNotification]: (contract: any) => this.onGroupChangeNotification(contract),
			[NotificationsServiceContractType.GroupGiveawayChangedNotification]: (contract: any) => this.onGroupGiveawayChangedNotification(contract),
			[NotificationsServiceContractType.GroupGiveawaySettingsNotification]: (contract: any) => this.onGroupGiveawaySettingsNotification(contract),
			[NotificationsServiceContractType.GroupInvitationNotification]: (contract: any) => this.onGroupInvitationNotification(contract),
			[NotificationsServiceContractType.GroupPollChangedNotification]: (contract: any) => this.onGroupPollChangedNotification(contract),
			[NotificationsServiceContractType.GroupPollSettingsNotification]: (contract: any) => this.onGroupPollSettingsNotification(contract),
			[NotificationsServiceContractType.GroupPreferenceNotification]: (contract: any) => this.onGroupPreferenceNotification(contract),
			[NotificationsServiceContractType.GroupPresenceNotification]: (contract: any) => this.onGroupPresenceNotification(contract),
			[NotificationsServiceContractType.JoinResponse]: (contract: any) => this.onJoinResponse(contract),
			[NotificationsServiceContractType.TwitchChatNoticeNotification]: (contract: any) => this.onTwitchChatNoticeNotification(contract),
			[NotificationsServiceContractType.UserBanStatusNotification]: (contract: any) => this.onUserBanStatusNotification(contract),
			[NotificationsServiceContractType.UserChangeNotification]: (contract: any) => this.onUserChangeNotification(contract),
			[NotificationsServiceContractType.UserClientSettingsNotification]: (contract: any) => this.onUserClientSettingsNotification(contract),
			[NotificationsServiceContractType.Handshake]: (contract: any) => this.onHandshake(contract),

        });
    }

    protected onSocketOpen(id: string) {
        super.onSocketOpen(id);
        this.events.connected(id);
    }

    protected onSocketClose(id: string, e: CloseEvent) {
        super.onSocketClose(id, e);
        setTimeout(() => this.events.disconnected(id));
    }

	sendConversationMessageRequest(contract:Curse_Friends_NotificationContracts.ConversationMessageRequest) {
		this.sendContract(NotificationsServiceContractType.ConversationMessageRequest, contract);
	}

	sendHealthCheckRequest(contract:Curse_Friends_NotificationContracts.HealthCheckRequest) {
		this.sendContract(NotificationsServiceContractType.HealthCheckRequest, contract);
	}

	sendJoinRequest(contract:Curse_Friends_NotificationContracts.JoinRequest) {
		this.sendContract(NotificationsServiceContractType.JoinRequest, contract);
	}

	sendHandshake(contract:Curse_SocketMessages.Handshake) {
		this.sendContract(NotificationsServiceContractType.Handshake, contract);
	}

	onCallNotification(contract:Curse_Friends_NotificationContracts.CallNotification) {
		 this.events.callNotification(contract);
	}

	onCallRespondedNotification(contract:Curse_Friends_NotificationContracts.CallRespondedNotification) {
		 this.events.callRespondedNotification(contract);
	}

	onConversationMessageNotification(contract:Curse_Friends_NotificationContracts.ConversationMessageNotification) {
		 this.events.conversationMessageNotification(contract);
	}

	onConversationMessageResponse(contract:Curse_Friends_NotificationContracts.ConversationMessageResponse) {
		 this.events.conversationMessageResponse(contract);
	}

	onConversationReadNotification(contract:Curse_Friends_NotificationContracts.ConversationReadNotification) {
		 this.events.conversationReadNotification(contract);
	}

	onExternalAccountChangedNotification(contract:Curse_Friends_NotificationContracts.ExternalAccountChangedNotification) {
		 this.events.externalAccountChangedNotification(contract);
	}

	onExternalCommunityLinkChangedNotification(contract:Curse_Friends_NotificationContracts.ExternalCommunityLinkChangedNotification) {
		 this.events.externalCommunityLinkChangedNotification(contract);
	}

	onFriendshipChangeNotification(contract:Curse_Friends_NotificationContracts.FriendshipChangeNotification) {
		 this.events.friendshipChangeNotification(contract);
	}

	onFriendshipRemovedNotification(contract:Curse_Friends_NotificationContracts.FriendshipRemovedNotification) {
		 this.events.friendshipRemovedNotification(contract);
	}

	onFriendSuggestionNotification(contract:Curse_Friends_NotificationContracts.FriendSuggestionNotification) {
		 this.events.friendSuggestionNotification(contract);
	}

	onGroupBulkMessageDeleteNotification(contract:Curse_Friends_NotificationContracts.GroupBulkMessageDeleteNotification) {
		 this.events.groupBulkMessageDeleteNotification(contract);
	}

	onGroupChangeNotification(contract:Curse_Friends_NotificationContracts.GroupChangeNotification) {
		 this.events.groupChangeNotification(contract);
	}

	onGroupGiveawayChangedNotification(contract:Curse_Friends_NotificationContracts.GroupGiveawayChangedNotification) {
		 this.events.groupGiveawayChangedNotification(contract);
	}

	onGroupGiveawaySettingsNotification(contract:Curse_Friends_NotificationContracts.GroupGiveawaySettingsNotification) {
		 this.events.groupGiveawaySettingsNotification(contract);
	}

	onGroupInvitationNotification(contract:Curse_Friends_NotificationContracts.GroupInvitationNotification) {
		 this.events.groupInvitationNotification(contract);
	}

	onGroupPollChangedNotification(contract:Curse_Friends_NotificationContracts.GroupPollChangedNotification) {
		 this.events.groupPollChangedNotification(contract);
	}

	onGroupPollSettingsNotification(contract:Curse_Friends_NotificationContracts.GroupPollSettingsNotification) {
		 this.events.groupPollSettingsNotification(contract);
	}

	onGroupPreferenceNotification(contract:Curse_Friends_NotificationContracts.GroupPreferenceNotification) {
		 this.events.groupPreferenceNotification(contract);
	}

	onGroupPresenceNotification(contract:Curse_Friends_NotificationContracts.GroupPresenceNotification) {
		 this.events.groupPresenceNotification(contract);
	}

	onJoinResponse(contract:Curse_Friends_NotificationContracts.JoinResponse) {
		 this.events.joinResponse(contract);
	}

	onTwitchChatNoticeNotification(contract:Curse_Friends_NotificationContracts.TwitchChatNoticeNotification) {
		 this.events.twitchChatNoticeNotification(contract);
	}

	onUserBanStatusNotification(contract:Curse_Friends_NotificationContracts.UserBanStatusNotification) {
		 this.events.userBanStatusNotification(contract);
	}

	onUserChangeNotification(contract:Curse_Friends_NotificationContracts.UserChangeNotification) {
		 this.events.userChangeNotification(contract);
	}

	onUserClientSettingsNotification(contract:Curse_Friends_NotificationContracts.UserClientSettingsNotification) {
		 this.events.userClientSettingsNotification(contract);
	}

	onHandshake(contract:Curse_SocketMessages.Handshake) {
		 this.events.handshake(contract);
	}


}