import * as Curse_Friends_PollsWebService_Contracts from './models/Curse.Friends.PollsWebService.Contracts';
import * as Curse_Friends_NotificationContracts from './models/Curse.Friends.NotificationContracts';
import * as Curse_Friends_Enums from './models/Curse.Friends.Enums';

import { BaseWebServiceClient as base } from './lib/BaseWebServiceClient';
export class PollService extends base {    

	getActive(groupID:string):Promise<Curse_Friends_PollsWebService_Contracts.ActivePollContract[]> {
		return this._get<Curse_Friends_PollsWebService_Contracts.ActivePollContract[]>(`polls/${groupID}`);
	}

	getActiveForRegion(regionKey:string, groupID:string):Promise<Curse_Friends_PollsWebService_Contracts.ActivePollContract[]> {
		return this._getForRegion<Curse_Friends_PollsWebService_Contracts.ActivePollContract[]>(regionKey,`polls/${groupID}`);
	}

	create(groupID:string, request:Curse_Friends_PollsWebService_Contracts.CreatePollRequest):Promise<Curse_Friends_NotificationContracts.GroupPollNotification> {
		return this._post<Curse_Friends_NotificationContracts.GroupPollNotification>(`polls/${groupID}`, request);
	}

	createForRegion(regionKey:string, groupID:string, request:Curse_Friends_PollsWebService_Contracts.CreatePollRequest):Promise<Curse_Friends_NotificationContracts.GroupPollNotification> {
		return this._postForRegion<Curse_Friends_NotificationContracts.GroupPollNotification>(regionKey,`polls/${groupID}`, request);
	}

	get(groupID:string, pollID:number):Promise<Curse_Friends_NotificationContracts.GroupPollNotification> {
		return this._get<Curse_Friends_NotificationContracts.GroupPollNotification>(`polls/${groupID}/${pollID}`);
	}

	getForRegion(regionKey:string, groupID:string, pollID:number):Promise<Curse_Friends_NotificationContracts.GroupPollNotification> {
		return this._getForRegion<Curse_Friends_NotificationContracts.GroupPollNotification>(regionKey,`polls/${groupID}/${pollID}`);
	}

	getLatestSettings(groupID:string):Promise<Curse_Friends_NotificationContracts.GroupPollSettingsNotification> {
		return this._get<Curse_Friends_NotificationContracts.GroupPollSettingsNotification>(`polls/${groupID}/settings`);
	}

	getLatestSettingsForRegion(regionKey:string, groupID:string):Promise<Curse_Friends_NotificationContracts.GroupPollSettingsNotification> {
		return this._getForRegion<Curse_Friends_NotificationContracts.GroupPollSettingsNotification>(regionKey,`polls/${groupID}/settings`);
	}

	getPollHistory(groupID:string, pageSize:number, pageNumber:number):Promise<Curse_Friends_PollsWebService_Contracts.GroupPollResult[]> {
		return this._get<Curse_Friends_PollsWebService_Contracts.GroupPollResult[]>(`polls/${groupID}/history?pageSize=${pageSize}&pageNumber=${pageNumber}`);
	}

	getPollHistoryForRegion(regionKey:string, groupID:string, pageSize:number, pageNumber:number):Promise<Curse_Friends_PollsWebService_Contracts.GroupPollResult[]> {
		return this._getForRegion<Curse_Friends_PollsWebService_Contracts.GroupPollResult[]>(regionKey,`polls/${groupID}/history?pageSize=${pageSize}&pageNumber=${pageNumber}`);
	}

	searchPollHistory(groupID:string, request:Curse_Friends_PollsWebService_Contracts.SearchPollHistoryRequest):Promise<Curse_Friends_PollsWebService_Contracts.GroupPollResult[]> {
		return this._post<Curse_Friends_PollsWebService_Contracts.GroupPollResult[]>(`polls/${groupID}/history/search`, request);
	}

	searchPollHistoryForRegion(regionKey:string, groupID:string, request:Curse_Friends_PollsWebService_Contracts.SearchPollHistoryRequest):Promise<Curse_Friends_PollsWebService_Contracts.GroupPollResult[]> {
		return this._postForRegion<Curse_Friends_PollsWebService_Contracts.GroupPollResult[]>(regionKey,`polls/${groupID}/history/search`, request);
	}

	end(groupID:string, pollID:number):Promise<void> {
		return this._delete<void>(`polls/${groupID}/${pollID}`);
	}

	endForRegion(regionKey:string, groupID:string, pollID:number):Promise<void> {
		return this._deleteForRegion<void>(regionKey,`polls/${groupID}/${pollID}`);
	}

	deactivate(groupID:string, pollID:number):Promise<void> {
		return this._delete<void>(`polls/${groupID}/${pollID}/deactivate`);
	}

	deactivateForRegion(regionKey:string, groupID:string, pollID:number):Promise<void> {
		return this._deleteForRegion<void>(regionKey,`polls/${groupID}/${pollID}/deactivate`);
	}

	getMyVote(groupID:string, pollID:number):Promise<number[]> {
		return this._get<number[]>(`polls/${groupID}/${pollID}/votes`);
	}

	getMyVoteForRegion(regionKey:string, groupID:string, pollID:number):Promise<number[]> {
		return this._getForRegion<number[]>(regionKey,`polls/${groupID}/${pollID}/votes`);
	}

	vote(groupID:string, pollID:number, vote:number[]):Promise<Curse_Friends_PollsWebService_Contracts.ActivePollContract> {
		return this._post<Curse_Friends_PollsWebService_Contracts.ActivePollContract>(`polls/${groupID}/${pollID}/votes`, vote);
	}

	voteForRegion(regionKey:string, groupID:string, pollID:number, vote:number[]):Promise<Curse_Friends_PollsWebService_Contracts.ActivePollContract> {
		return this._postForRegion<Curse_Friends_PollsWebService_Contracts.ActivePollContract>(regionKey,`polls/${groupID}/${pollID}/votes`, vote);
	}

	getPublicPoll(pollCode:string):Promise<Curse_Friends_PollsWebService_Contracts.PublicActivePollContract> {
		return this._get<Curse_Friends_PollsWebService_Contracts.PublicActivePollContract>(`polls/public/${pollCode}`);
	}

	getPublicPollForRegion(regionKey:string, pollCode:string):Promise<Curse_Friends_PollsWebService_Contracts.PublicActivePollContract> {
		return this._getForRegion<Curse_Friends_PollsWebService_Contracts.PublicActivePollContract>(regionKey,`polls/public/${pollCode}`);
	}

	votePublicPoll(pollCode:string, votes:number[]):Promise<Curse_Friends_PollsWebService_Contracts.PublicActivePollContract> {
		return this._post<Curse_Friends_PollsWebService_Contracts.PublicActivePollContract>(`polls/public/${pollCode}/votes`, votes);
	}

	votePublicPollForRegion(regionKey:string, pollCode:string, votes:number[]):Promise<Curse_Friends_PollsWebService_Contracts.PublicActivePollContract> {
		return this._postForRegion<Curse_Friends_PollsWebService_Contracts.PublicActivePollContract>(regionKey,`polls/public/${pollCode}/votes`, votes);
	}



}