import * as Curse_Friends_GroupsWebService_Contracts from './models/Curse.Friends.GroupsWebService.Contracts';
import * as Curse_Friends_NotificationContracts from './models/Curse.Friends.NotificationContracts';
import * as Curse_Friends_Enums from './models/Curse.Friends.Enums';

import { BaseWebServiceClient as base } from './lib/BaseWebServiceClient';
export class PrivateMessagesService extends base {    

	getAll(groupID:string):Promise<Curse_Friends_NotificationContracts.GroupPrivateConversationContract[]> {
		return this._get<Curse_Friends_NotificationContracts.GroupPrivateConversationContract[]>(`groups/${groupID}/private-messages`);
	}

	getAllForRegion(regionKey:string, groupID:string):Promise<Curse_Friends_NotificationContracts.GroupPrivateConversationContract[]> {
		return this._getForRegion<Curse_Friends_NotificationContracts.GroupPrivateConversationContract[]>(regionKey,`groups/${groupID}/private-messages`);
	}

	block(groupID:string, userID:number):Promise<void> {
		return this._post<void>(`groups/${groupID}/private-messages/${userID}/block`);
	}

	blockForRegion(regionKey:string, groupID:string, userID:number):Promise<void> {
		return this._postForRegion<void>(regionKey,`groups/${groupID}/private-messages/${userID}/block`);
	}

	unblock(groupID:string, userID:number):Promise<void> {
		return this._post<void>(`groups/${groupID}/private-messages/${userID}/unblock`);
	}

	unblockForRegion(regionKey:string, groupID:string, userID:number):Promise<void> {
		return this._postForRegion<void>(regionKey,`groups/${groupID}/private-messages/${userID}/unblock`);
	}

	hide(groupID:string, userID:number):Promise<void> {
		return this._post<void>(`groups/${groupID}/private-messages/${userID}/hide`);
	}

	hideForRegion(regionKey:string, groupID:string, userID:number):Promise<void> {
		return this._postForRegion<void>(regionKey,`groups/${groupID}/private-messages/${userID}/hide`);
	}

	unhide(groupID:string, userID:number):Promise<void> {
		return this._post<void>(`groups/${groupID}/private-messages/${userID}/unhide`);
	}

	unhideForRegion(regionKey:string, groupID:string, userID:number):Promise<void> {
		return this._postForRegion<void>(regionKey,`groups/${groupID}/private-messages/${userID}/unhide`);
	}



}