import * as Curse_Friends_LoginsWebService_Contracts from './models/Curse.Friends.LoginsWebService.Contracts';
import * as Curse_Friends_Enums from './models/Curse.Friends.Enums';

import { BaseWebServiceClient as base } from './lib/BaseWebServiceClient';
export class RegisterService extends base {    

	register(registerRequest:Curse_Friends_LoginsWebService_Contracts.RegisterRequest):Promise<Curse_Friends_LoginsWebService_Contracts.RegisterResponse> {
		return this._post<Curse_Friends_LoginsWebService_Contracts.RegisterResponse>(`register`, registerRequest);
	}

	registerForRegion(regionKey:string, registerRequest:Curse_Friends_LoginsWebService_Contracts.RegisterRequest):Promise<Curse_Friends_LoginsWebService_Contracts.RegisterResponse> {
		return this._postForRegion<Curse_Friends_LoginsWebService_Contracts.RegisterResponse>(regionKey,`register`, registerRequest);
	}

	checkUsername(username:string):Promise<boolean> {
		return this._post<boolean>(`register/check-username`, username);
	}

	checkUsernameForRegion(regionKey:string, username:string):Promise<boolean> {
		return this._postForRegion<boolean>(regionKey,`register/check-username`, username);
	}

	registerTempAccount(registerRequest:Curse_Friends_LoginsWebService_Contracts.RegisterTempRequest):Promise<Curse_Friends_LoginsWebService_Contracts.RegisterTempResponse> {
		return this._post<Curse_Friends_LoginsWebService_Contracts.RegisterTempResponse>(`register/create-temp`, registerRequest);
	}

	registerTempAccountForRegion(regionKey:string, registerRequest:Curse_Friends_LoginsWebService_Contracts.RegisterTempRequest):Promise<Curse_Friends_LoginsWebService_Contracts.RegisterTempResponse> {
		return this._postForRegion<Curse_Friends_LoginsWebService_Contracts.RegisterTempResponse>(regionKey,`register/create-temp`, registerRequest);
	}

	claimTempAccount(claimRequest:Curse_Friends_LoginsWebService_Contracts.ClaimTempRequest):Promise<Curse_Friends_LoginsWebService_Contracts.RegisterResponse> {
		return this._post<Curse_Friends_LoginsWebService_Contracts.RegisterResponse>(`register/claim-temp`, claimRequest);
	}

	claimTempAccountForRegion(regionKey:string, claimRequest:Curse_Friends_LoginsWebService_Contracts.ClaimTempRequest):Promise<Curse_Friends_LoginsWebService_Contracts.RegisterResponse> {
		return this._postForRegion<Curse_Friends_LoginsWebService_Contracts.RegisterResponse>(regionKey,`register/claim-temp`, claimRequest);
	}



}