import * as Curse_Friends_ReportingWebService_Contracts from './models/Curse.Friends.ReportingWebService.Contracts';
import * as Curse_Friends_Enums from './models/Curse.Friends.Enums';

import { BaseWebServiceClient as base } from './lib/BaseWebServiceClient';
export class ReportingService extends base {    

	usage(usageProfile:Curse_Friends_ReportingWebService_Contracts.UsageProfile):Promise<void> {
		return this._post<void>(`reporting/usage`, usageProfile);
	}

	usageForRegion(regionKey:string, usageProfile:Curse_Friends_ReportingWebService_Contracts.UsageProfile):Promise<void> {
		return this._postForRegion<void>(regionKey,`reporting/usage`, usageProfile);
	}

	reportEvent(data:Curse_Friends_ReportingWebService_Contracts.EventReportContract[]):Promise<void> {
		return this._post<void>(`reporting/events`, data);
	}

	reportEventForRegion(regionKey:string, data:Curse_Friends_ReportingWebService_Contracts.EventReportContract[]):Promise<void> {
		return this._postForRegion<void>(regionKey,`reporting/events`, data);
	}



}