import * as Curse_Friends_GroupsWebService_Contracts from './models/Curse.Friends.GroupsWebService.Contracts';
import * as Curse_Friends_NotificationContracts from './models/Curse.Friends.NotificationContracts';
import * as Curse_Friends_Enums from './models/Curse.Friends.Enums';

import { BaseWebServiceClient as base } from './lib/BaseWebServiceClient';
export class ServersService extends base {    

	simpleSearch(query:string, pageSize:number, pageNumber:number):Promise<Curse_Friends_NotificationContracts.GroupSearchModelContract[]> {
		return this._get<Curse_Friends_NotificationContracts.GroupSearchModelContract[]>(`servers?query=${encodeURIComponent(query)}&pageSize=${pageSize}&pageNumber=${pageNumber}`);
	}

	simpleSearchForRegion(regionKey:string, query:string, pageSize:number, pageNumber:number):Promise<Curse_Friends_NotificationContracts.GroupSearchModelContract[]> {
		return this._getForRegion<Curse_Friends_NotificationContracts.GroupSearchModelContract[]>(regionKey,`servers?query=${encodeURIComponent(query)}&pageSize=${pageSize}&pageNumber=${pageNumber}`);
	}

	search(request:Curse_Friends_GroupsWebService_Contracts.SearchServersRequest):Promise<Curse_Friends_NotificationContracts.GroupSearchModelContract[]> {
		return this._post<Curse_Friends_NotificationContracts.GroupSearchModelContract[]>(`servers/search`, request);
	}

	searchForRegion(regionKey:string, request:Curse_Friends_GroupsWebService_Contracts.SearchServersRequest):Promise<Curse_Friends_NotificationContracts.GroupSearchModelContract[]> {
		return this._postForRegion<Curse_Friends_NotificationContracts.GroupSearchModelContract[]>(regionKey,`servers/search`, request);
	}

	simpleDiscover(query:string, pageSize:number, pageNumber:number):Promise<Curse_Friends_NotificationContracts.GroupSearchModelContract[]> {
		return this._get<Curse_Friends_NotificationContracts.GroupSearchModelContract[]>(`servers/simple-discover?query=${encodeURIComponent(query)}&pageSize=${pageSize}&pageNumber=${pageNumber}`);
	}

	simpleDiscoverForRegion(regionKey:string, query:string, pageSize:number, pageNumber:number):Promise<Curse_Friends_NotificationContracts.GroupSearchModelContract[]> {
		return this._getForRegion<Curse_Friends_NotificationContracts.GroupSearchModelContract[]>(regionKey,`servers/simple-discover?query=${encodeURIComponent(query)}&pageSize=${pageSize}&pageNumber=${pageNumber}`);
	}

	advancedDiscover(request:Curse_Friends_GroupsWebService_Contracts.DiscoverRequest):Promise<Curse_Friends_GroupsWebService_Contracts.DiscoverResponse> {
		return this._post<Curse_Friends_GroupsWebService_Contracts.DiscoverResponse>(`servers/advanced-discover`, request);
	}

	advancedDiscoverForRegion(regionKey:string, request:Curse_Friends_GroupsWebService_Contracts.DiscoverRequest):Promise<Curse_Friends_GroupsWebService_Contracts.DiscoverResponse> {
		return this._postForRegion<Curse_Friends_GroupsWebService_Contracts.DiscoverResponse>(regionKey,`servers/advanced-discover`, request);
	}

	creationOptions():Promise<Curse_Friends_GroupsWebService_Contracts.ServerCreationOptionsResponse> {
		return this._get<Curse_Friends_GroupsWebService_Contracts.ServerCreationOptionsResponse>(`servers/creation-options`);
	}

	creationOptionsForRegion(regionKey:string):Promise<Curse_Friends_GroupsWebService_Contracts.ServerCreationOptionsResponse> {
		return this._getForRegion<Curse_Friends_GroupsWebService_Contracts.ServerCreationOptionsResponse>(regionKey,`servers/creation-options`);
	}

	create(request:Curse_Friends_GroupsWebService_Contracts.CreateServerRequest):Promise<Curse_Friends_NotificationContracts.GroupNotification> {
		return this._post<Curse_Friends_NotificationContracts.GroupNotification>(`servers`, request);
	}

	createForRegion(regionKey:string, request:Curse_Friends_GroupsWebService_Contracts.CreateServerRequest):Promise<Curse_Friends_NotificationContracts.GroupNotification> {
		return this._postForRegion<Curse_Friends_NotificationContracts.GroupNotification>(regionKey,`servers`, request);
	}

	createStreamCommunity(request:Curse_Friends_GroupsWebService_Contracts.CreateStreamerCommunityGroupRequest):Promise<Curse_Friends_GroupsWebService_Contracts.CreateStreamerCommunityGroupResponse> {
		return this._post<Curse_Friends_GroupsWebService_Contracts.CreateStreamerCommunityGroupResponse>(`servers/stream-community`, request);
	}

	createStreamCommunityForRegion(regionKey:string, request:Curse_Friends_GroupsWebService_Contracts.CreateStreamerCommunityGroupRequest):Promise<Curse_Friends_GroupsWebService_Contracts.CreateStreamerCommunityGroupResponse> {
		return this._postForRegion<Curse_Friends_GroupsWebService_Contracts.CreateStreamerCommunityGroupResponse>(regionKey,`servers/stream-community`, request);
	}

	createGuildCommunity(request:Curse_Friends_GroupsWebService_Contracts.CreateGuildCommunityRequest):Promise<Curse_Friends_NotificationContracts.GroupNotification> {
		return this._post<Curse_Friends_NotificationContracts.GroupNotification>(`servers/guild-community`, request);
	}

	createGuildCommunityForRegion(regionKey:string, request:Curse_Friends_GroupsWebService_Contracts.CreateGuildCommunityRequest):Promise<Curse_Friends_NotificationContracts.GroupNotification> {
		return this._postForRegion<Curse_Friends_NotificationContracts.GroupNotification>(regionKey,`servers/guild-community`, request);
	}

	createSyncedGuildServer(request:Curse_Friends_GroupsWebService_Contracts.CreateSyncedGuildServerRequest):Promise<Curse_Friends_GroupsWebService_Contracts.CreateSyncedGuildServerResponse> {
		return this._post<Curse_Friends_GroupsWebService_Contracts.CreateSyncedGuildServerResponse>(`servers/synced-guild`, request);
	}

	createSyncedGuildServerForRegion(regionKey:string, request:Curse_Friends_GroupsWebService_Contracts.CreateSyncedGuildServerRequest):Promise<Curse_Friends_GroupsWebService_Contracts.CreateSyncedGuildServerResponse> {
		return this._postForRegion<Curse_Friends_GroupsWebService_Contracts.CreateSyncedGuildServerResponse>(regionKey,`servers/synced-guild`, request);
	}

	getFromUrl(url:string):Promise<string> {
		return this._get<string>(`servers/url/${url}`);
	}

	getFromUrlForRegion(regionKey:string, url:string):Promise<string> {
		return this._getForRegion<string>(regionKey,`servers/url/${url}`);
	}

	validateUrl(url:string):Promise<Curse_Friends_GroupsWebService_Contracts.ValidateUrlStatus> {
		return this._get<Curse_Friends_GroupsWebService_Contracts.ValidateUrlStatus>(`servers/url/${url}/validate`);
	}

	validateUrlForRegion(regionKey:string, url:string):Promise<Curse_Friends_GroupsWebService_Contracts.ValidateUrlStatus> {
		return this._getForRegion<Curse_Friends_GroupsWebService_Contracts.ValidateUrlStatus>(regionKey,`servers/url/${url}/validate`);
	}

	getGeneralSettings(groupID:string):Promise<Curse_Friends_GroupsWebService_Contracts.ServerGeneralSettingsContract> {
		return this._get<Curse_Friends_GroupsWebService_Contracts.ServerGeneralSettingsContract>(`servers/${groupID}/settings/general`);
	}

	getGeneralSettingsForRegion(regionKey:string, groupID:string):Promise<Curse_Friends_GroupsWebService_Contracts.ServerGeneralSettingsContract> {
		return this._getForRegion<Curse_Friends_GroupsWebService_Contracts.ServerGeneralSettingsContract>(regionKey,`servers/${groupID}/settings/general`);
	}

	setGeneralSettings(groupID:string, request:Curse_Friends_GroupsWebService_Contracts.ServerGeneralSettingsContract):Promise<void> {
		return this._post<void>(`servers/${groupID}/settings/general`, request);
	}

	setGeneralSettingsForRegion(regionKey:string, groupID:string, request:Curse_Friends_GroupsWebService_Contracts.ServerGeneralSettingsContract):Promise<void> {
		return this._postForRegion<void>(regionKey,`servers/${groupID}/settings/general`, request);
	}

	getSearchSettings(groupID:string):Promise<Curse_Friends_GroupsWebService_Contracts.ServerSearchSettingsContract> {
		return this._get<Curse_Friends_GroupsWebService_Contracts.ServerSearchSettingsContract>(`servers/${groupID}/settings/search`);
	}

	getSearchSettingsForRegion(regionKey:string, groupID:string):Promise<Curse_Friends_GroupsWebService_Contracts.ServerSearchSettingsContract> {
		return this._getForRegion<Curse_Friends_GroupsWebService_Contracts.ServerSearchSettingsContract>(regionKey,`servers/${groupID}/settings/search`);
	}

	setSearchSettings(groupID:string, request:Curse_Friends_GroupsWebService_Contracts.ServerSearchSettingsContract):Promise<void> {
		return this._post<void>(`servers/${groupID}/settings/search`, request);
	}

	setSearchSettingsForRegion(regionKey:string, groupID:string, request:Curse_Friends_GroupsWebService_Contracts.ServerSearchSettingsContract):Promise<void> {
		return this._postForRegion<void>(regionKey,`servers/${groupID}/settings/search`, request);
	}

	createChannel(groupID:string, request:Curse_Friends_GroupsWebService_Contracts.CreateChannelRequest):Promise<Curse_Friends_NotificationContracts.ChannelContract> {
		return this._post<Curse_Friends_NotificationContracts.ChannelContract>(`servers/${groupID}/channels`, request);
	}

	createChannelForRegion(regionKey:string, groupID:string, request:Curse_Friends_GroupsWebService_Contracts.CreateChannelRequest):Promise<Curse_Friends_NotificationContracts.ChannelContract> {
		return this._postForRegion<Curse_Friends_NotificationContracts.ChannelContract>(regionKey,`servers/${groupID}/channels`, request);
	}

	deleteChannel(groupID:string, channelID:string):Promise<void> {
		return this._delete<void>(`servers/${groupID}/channels/${channelID}`);
	}

	deleteChannelForRegion(regionKey:string, groupID:string, channelID:string):Promise<void> {
		return this._deleteForRegion<void>(regionKey,`servers/${groupID}/channels/${channelID}`);
	}

	channelSettings(groupID:string, channelID:string, request:Curse_Friends_GroupsWebService_Contracts.ModifyChannelSettingsRequest):Promise<void> {
		return this._post<void>(`servers/${groupID}/channels/${channelID}/settings`, request);
	}

	channelSettingsForRegion(regionKey:string, groupID:string, channelID:string, request:Curse_Friends_GroupsWebService_Contracts.ModifyChannelSettingsRequest):Promise<void> {
		return this._postForRegion<void>(regionKey,`servers/${groupID}/channels/${channelID}/settings`, request);
	}

	delete(groupID:string):Promise<void> {
		return this._delete<void>(`servers/${groupID}`);
	}

	deleteForRegion(regionKey:string, groupID:string):Promise<void> {
		return this._deleteForRegion<void>(regionKey,`servers/${groupID}`);
	}

	restore(groupID:string):Promise<void> {
		return this._post<void>(`servers/${groupID}/restore`);
	}

	restoreForRegion(regionKey:string, groupID:string):Promise<void> {
		return this._postForRegion<void>(regionKey,`servers/${groupID}/restore`);
	}

	reorder(groupID:string, request:Curse_Friends_GroupsWebService_Contracts.ReorganizeGroupRequest):Promise<Curse_Friends_NotificationContracts.GroupNotification> {
		return this._post<Curse_Friends_NotificationContracts.GroupNotification>(`servers/${groupID}/reorder`, request);
	}

	reorderForRegion(regionKey:string, groupID:string, request:Curse_Friends_GroupsWebService_Contracts.ReorganizeGroupRequest):Promise<Curse_Friends_NotificationContracts.GroupNotification> {
		return this._postForRegion<Curse_Friends_NotificationContracts.GroupNotification>(regionKey,`servers/${groupID}/reorder`, request);
	}

	joinServer(groupID:string):Promise<Curse_Friends_NotificationContracts.GroupNotification> {
		return this._post<Curse_Friends_NotificationContracts.GroupNotification>(`servers/${groupID}/join`);
	}

	joinServerForRegion(regionKey:string, groupID:string):Promise<Curse_Friends_NotificationContracts.GroupNotification> {
		return this._postForRegion<Curse_Friends_NotificationContracts.GroupNotification>(regionKey,`servers/${groupID}/join`);
	}

	addEmoticon(groupID:string, request:Curse_Friends_GroupsWebService_Contracts.AddEmoticonRequest):Promise<void> {
		return this._post<void>(`servers/${groupID}/emoticons`, request);
	}

	addEmoticonForRegion(regionKey:string, groupID:string, request:Curse_Friends_GroupsWebService_Contracts.AddEmoticonRequest):Promise<void> {
		return this._postForRegion<void>(regionKey,`servers/${groupID}/emoticons`, request);
	}

	removeEmoticon(groupID:string, id:string):Promise<void> {
		return this._delete<void>(`servers/${groupID}/emoticons/${id}`);
	}

	removeEmoticonForRegion(regionKey:string, groupID:string, id:string):Promise<void> {
		return this._deleteForRegion<void>(regionKey,`servers/${groupID}/emoticons/${id}`);
	}

	getRoles(groupID:string):Promise<Curse_Friends_GroupsWebService_Contracts.GroupRoleDetails[]> {
		return this._get<Curse_Friends_GroupsWebService_Contracts.GroupRoleDetails[]>(`servers/${groupID}/roles`);
	}

	getRolesForRegion(regionKey:string, groupID:string):Promise<Curse_Friends_GroupsWebService_Contracts.GroupRoleDetails[]> {
		return this._getForRegion<Curse_Friends_GroupsWebService_Contracts.GroupRoleDetails[]>(regionKey,`servers/${groupID}/roles`);
	}

	getRole(groupID:string, roleID:number):Promise<Curse_Friends_GroupsWebService_Contracts.GroupRoleDetails> {
		return this._get<Curse_Friends_GroupsWebService_Contracts.GroupRoleDetails>(`servers/${groupID}/roles/${roleID}`);
	}

	getRoleForRegion(regionKey:string, groupID:string, roleID:number):Promise<Curse_Friends_GroupsWebService_Contracts.GroupRoleDetails> {
		return this._getForRegion<Curse_Friends_GroupsWebService_Contracts.GroupRoleDetails>(regionKey,`servers/${groupID}/roles/${roleID}`);
	}

	createRole(groupID:string, request:Curse_Friends_GroupsWebService_Contracts.CreateGroupRoleRequest):Promise<Curse_Friends_GroupsWebService_Contracts.GroupRoleDetails> {
		return this._post<Curse_Friends_GroupsWebService_Contracts.GroupRoleDetails>(`servers/${groupID}/roles`, request);
	}

	createRoleForRegion(regionKey:string, groupID:string, request:Curse_Friends_GroupsWebService_Contracts.CreateGroupRoleRequest):Promise<Curse_Friends_GroupsWebService_Contracts.GroupRoleDetails> {
		return this._postForRegion<Curse_Friends_GroupsWebService_Contracts.GroupRoleDetails>(regionKey,`servers/${groupID}/roles`, request);
	}

	modifyRole(groupID:string, roleID:number, request:Curse_Friends_GroupsWebService_Contracts.ModifyGroupRoleRequest):Promise<Curse_Friends_GroupsWebService_Contracts.GroupRoleDetails> {
		return this._post<Curse_Friends_GroupsWebService_Contracts.GroupRoleDetails>(`servers/${groupID}/roles/${roleID}`, request);
	}

	modifyRoleForRegion(regionKey:string, groupID:string, roleID:number, request:Curse_Friends_GroupsWebService_Contracts.ModifyGroupRoleRequest):Promise<Curse_Friends_GroupsWebService_Contracts.GroupRoleDetails> {
		return this._postForRegion<Curse_Friends_GroupsWebService_Contracts.GroupRoleDetails>(regionKey,`servers/${groupID}/roles/${roleID}`, request);
	}

	modifyRoleRanks(groupID:string, roleRanks:{ [key: number]: number }):Promise<Curse_Friends_GroupsWebService_Contracts.GroupRoleDetails[]> {
		return this._post<Curse_Friends_GroupsWebService_Contracts.GroupRoleDetails[]>(`servers/${groupID}/roles/ranks`, roleRanks);
	}

	modifyRoleRanksForRegion(regionKey:string, groupID:string, roleRanks:{ [key: number]: number }):Promise<Curse_Friends_GroupsWebService_Contracts.GroupRoleDetails[]> {
		return this._postForRegion<Curse_Friends_GroupsWebService_Contracts.GroupRoleDetails[]>(regionKey,`servers/${groupID}/roles/ranks`, roleRanks);
	}

	deleteRole(groupID:string, roleID:number):Promise<void> {
		return this._delete<void>(`servers/${groupID}/roles/${roleID}`);
	}

	deleteRoleForRegion(regionKey:string, groupID:string, roleID:number):Promise<void> {
		return this._deleteForRegion<void>(regionKey,`servers/${groupID}/roles/${roleID}`);
	}

	modifyRolePermissions(groupID:string, channelID:string, roleID:number, request:Curse_Friends_GroupsWebService_Contracts.ModifyGroupRolePermissionsRequest):Promise<Curse_Friends_GroupsWebService_Contracts.GroupRoleDetails> {
		return this._post<Curse_Friends_GroupsWebService_Contracts.GroupRoleDetails>(`servers/${groupID}/roles/${roleID}/permissions/${channelID}`, request);
	}

	modifyRolePermissionsForRegion(regionKey:string, groupID:string, channelID:string, roleID:number, request:Curse_Friends_GroupsWebService_Contracts.ModifyGroupRolePermissionsRequest):Promise<Curse_Friends_GroupsWebService_Contracts.GroupRoleDetails> {
		return this._postForRegion<Curse_Friends_GroupsWebService_Contracts.GroupRoleDetails>(regionKey,`servers/${groupID}/roles/${roleID}/permissions/${channelID}`, request);
	}

	addMemberRole(groupID:string, userID:number, roleID:number):Promise<Curse_Friends_NotificationContracts.GroupMemberContract> {
		return this._post<Curse_Friends_NotificationContracts.GroupMemberContract>(`servers/${groupID}/members/${userID}/roles`, roleID);
	}

	addMemberRoleForRegion(regionKey:string, groupID:string, userID:number, roleID:number):Promise<Curse_Friends_NotificationContracts.GroupMemberContract> {
		return this._postForRegion<Curse_Friends_NotificationContracts.GroupMemberContract>(regionKey,`servers/${groupID}/members/${userID}/roles`, roleID);
	}

	removeMemberRole(groupID:string, userID:number, roleID:number):Promise<Curse_Friends_NotificationContracts.GroupMemberContract> {
		return this._delete<Curse_Friends_NotificationContracts.GroupMemberContract>(`servers/${groupID}/members/${userID}/roles/${roleID}`);
	}

	removeMemberRoleForRegion(regionKey:string, groupID:string, userID:number, roleID:number):Promise<Curse_Friends_NotificationContracts.GroupMemberContract> {
		return this._deleteForRegion<Curse_Friends_NotificationContracts.GroupMemberContract>(regionKey,`servers/${groupID}/members/${userID}/roles/${roleID}`);
	}

	createInvite(groupID:string, request:Curse_Friends_GroupsWebService_Contracts.CreateGroupInviteRequest):Promise<Curse_Friends_NotificationContracts.GroupInvitationNotification> {
		return this._post<Curse_Friends_NotificationContracts.GroupInvitationNotification>(`servers/${groupID}/invites`, request);
	}

	createInviteForRegion(regionKey:string, groupID:string, request:Curse_Friends_GroupsWebService_Contracts.CreateGroupInviteRequest):Promise<Curse_Friends_NotificationContracts.GroupInvitationNotification> {
		return this._postForRegion<Curse_Friends_NotificationContracts.GroupInvitationNotification>(regionKey,`servers/${groupID}/invites`, request);
	}

	getInvites(groupID:string, myInvitesOnly:boolean, activeInvitesOnly:boolean):Promise<Curse_Friends_NotificationContracts.GroupInvitationNotification[]> {
		return this._get<Curse_Friends_NotificationContracts.GroupInvitationNotification[]>(`servers/${groupID}/invites?myInvitesOnly=${myInvitesOnly}&activeInvitesOnly=${activeInvitesOnly}`);
	}

	getInvitesForRegion(regionKey:string, groupID:string, myInvitesOnly:boolean, activeInvitesOnly:boolean):Promise<Curse_Friends_NotificationContracts.GroupInvitationNotification[]> {
		return this._getForRegion<Curse_Friends_NotificationContracts.GroupInvitationNotification[]>(regionKey,`servers/${groupID}/invites?myInvitesOnly=${myInvitesOnly}&activeInvitesOnly=${activeInvitesOnly}`);
	}

	deleteInvite(groupID:string, inviteCode:string, removeGuests:boolean):Promise<void> {
		return this._delete<void>(`servers/${groupID}/invites/${inviteCode}?removeGuests=${removeGuests}`);
	}

	deleteInviteForRegion(regionKey:string, groupID:string, inviteCode:string, removeGuests:boolean):Promise<void> {
		return this._deleteForRegion<void>(regionKey,`servers/${groupID}/invites/${inviteCode}?removeGuests=${removeGuests}`);
	}

	getBanList(serverID:string, query:string, pageSize:number, pageNumber:number):Promise<Curse_Friends_GroupsWebService_Contracts.GroupBannedUserContract[]> {
		return this._get<Curse_Friends_GroupsWebService_Contracts.GroupBannedUserContract[]>(`servers/${serverID}/bans?query=${encodeURIComponent(query)}&pageSize=${pageSize}&pageNumber=${pageNumber}`);
	}

	getBanListForRegion(regionKey:string, serverID:string, query:string, pageSize:number, pageNumber:number):Promise<Curse_Friends_GroupsWebService_Contracts.GroupBannedUserContract[]> {
		return this._getForRegion<Curse_Friends_GroupsWebService_Contracts.GroupBannedUserContract[]>(regionKey,`servers/${serverID}/bans?query=${encodeURIComponent(query)}&pageSize=${pageSize}&pageNumber=${pageNumber}`);
	}

	searchBannedUsers(serverID:string, request:Curse_Friends_GroupsWebService_Contracts.SearchBannedUsersRequest):Promise<Curse_Friends_GroupsWebService_Contracts.GroupBannedUserContract[]> {
		return this._post<Curse_Friends_GroupsWebService_Contracts.GroupBannedUserContract[]>(`servers/${serverID}/bans/search`, request);
	}

	searchBannedUsersForRegion(regionKey:string, serverID:string, request:Curse_Friends_GroupsWebService_Contracts.SearchBannedUsersRequest):Promise<Curse_Friends_GroupsWebService_Contracts.GroupBannedUserContract[]> {
		return this._postForRegion<Curse_Friends_GroupsWebService_Contracts.GroupBannedUserContract[]>(regionKey,`servers/${serverID}/bans/search`, request);
	}

	banUser(serverID:string, request:Curse_Friends_GroupsWebService_Contracts.BanUserRequest):Promise<Curse_Friends_GroupsWebService_Contracts.GroupBannedUserContract> {
		return this._post<Curse_Friends_GroupsWebService_Contracts.GroupBannedUserContract>(`servers/${serverID}/bans`, request);
	}

	banUserForRegion(regionKey:string, serverID:string, request:Curse_Friends_GroupsWebService_Contracts.BanUserRequest):Promise<Curse_Friends_GroupsWebService_Contracts.GroupBannedUserContract> {
		return this._postForRegion<Curse_Friends_GroupsWebService_Contracts.GroupBannedUserContract>(regionKey,`servers/${serverID}/bans`, request);
	}

	banUserOld(serverID:string, userID:number, reason:string):Promise<Curse_Friends_GroupsWebService_Contracts.GroupBannedUserContract> {
		return this._post<Curse_Friends_GroupsWebService_Contracts.GroupBannedUserContract>(`servers/${serverID}/bans/${userID}`, reason);
	}

	banUserOldForRegion(regionKey:string, serverID:string, userID:number, reason:string):Promise<Curse_Friends_GroupsWebService_Contracts.GroupBannedUserContract> {
		return this._postForRegion<Curse_Friends_GroupsWebService_Contracts.GroupBannedUserContract>(regionKey,`servers/${serverID}/bans/${userID}`, reason);
	}

	unbanUser(serverID:string, userID:number):Promise<void> {
		return this._delete<void>(`servers/${serverID}/bans/${userID}`);
	}

	unbanUserForRegion(regionKey:string, serverID:string, userID:number):Promise<void> {
		return this._deleteForRegion<void>(regionKey,`servers/${serverID}/bans/${userID}`);
	}

	getLiveStreamDetails(serverID:string):Promise<Curse_Friends_NotificationContracts.ExternalCommunityPublicContract[]> {
		return this._get<Curse_Friends_NotificationContracts.ExternalCommunityPublicContract[]>(`servers/${serverID}/live-streams`);
	}

	getLiveStreamDetailsForRegion(regionKey:string, serverID:string):Promise<Curse_Friends_NotificationContracts.ExternalCommunityPublicContract[]> {
		return this._getForRegion<Curse_Friends_NotificationContracts.ExternalCommunityPublicContract[]>(regionKey,`servers/${serverID}/live-streams`);
	}



}