import * as Curse_Friends_SessionsWebService_Contracts from './models/Curse.Friends.SessionsWebService.Contracts';
import * as Curse_Friends_NotificationContracts from './models/Curse.Friends.NotificationContracts';
import * as Curse_Friends_Enums from './models/Curse.Friends.Enums';

import { BaseWebServiceClient as base } from './lib/BaseWebServiceClient';
export class SessionService extends base {    

	create(request:Curse_Friends_SessionsWebService_Contracts.CreateSessionRequest):Promise<Curse_Friends_SessionsWebService_Contracts.CreateSessionResponse> {
		return this._post<Curse_Friends_SessionsWebService_Contracts.CreateSessionResponse>(`sessions`, request);
	}

	createForRegion(regionKey:string, request:Curse_Friends_SessionsWebService_Contracts.CreateSessionRequest):Promise<Curse_Friends_SessionsWebService_Contracts.CreateSessionResponse> {
		return this._postForRegion<Curse_Friends_SessionsWebService_Contracts.CreateSessionResponse>(regionKey,`sessions`, request);
	}

	logout():Promise<void> {
		return this._delete<void>(`sessions`);
	}

	logoutForRegion(regionKey:string):Promise<void> {
		return this._deleteForRegion<void>(regionKey,`sessions`);
	}

	update(machineKey:string, request:Curse_Friends_SessionsWebService_Contracts.UpdateDeviceTokensRequest):Promise<void> {
		return this._post<void>(`sessions/${machineKey}/tokens`, request);
	}

	updateForRegion(regionKey:string, machineKey:string, request:Curse_Friends_SessionsWebService_Contracts.UpdateDeviceTokensRequest):Promise<void> {
		return this._postForRegion<void>(regionKey,`sessions/${machineKey}/tokens`, request);
	}

	delete(machineKey:string, deviceID:string):Promise<void> {
		return this._delete<void>(`sessions/${machineKey}/tokens/${deviceID}`);
	}

	deleteForRegion(regionKey:string, machineKey:string, deviceID:string):Promise<void> {
		return this._deleteForRegion<void>(regionKey,`sessions/${machineKey}/tokens/${deviceID}`);
	}

	updateCurrentGroup(machineKey:string, request:Curse_Friends_SessionsWebService_Contracts.UpdateCurrentGroupRequest):Promise<void> {
		return this._post<void>(`sessions/${machineKey}/group`, request);
	}

	updateCurrentGroupForRegion(regionKey:string, machineKey:string, request:Curse_Friends_SessionsWebService_Contracts.UpdateCurrentGroupRequest):Promise<void> {
		return this._postForRegion<void>(regionKey,`sessions/${machineKey}/group`, request);
	}



}